/*
 * 4/15/03 RALPH: It's stable now. It always succeeds with the 6-letter
 * keyword, when it starts with keywdsize = 2,3,4,... . With a
 * 12-letter keyword, it sometimes succeeds when I give it the keywdsize=12.
 *
 * 4/15/03 4:15 PM. Ralph, this is no longer stable. I've been trying 
 *  various experiments, including tweaking the current best key rather
 *  than starting over with a completely random key.
 *
 * 4/23/03 12:02 am Ralph. This version uses ideas that I found online.
 *  The main idea is that rather than randomly transpose letters in the key,
 *  we sometimes swap rows, or columns or reflect the key horizontally or
 *  vertically, or rotate rows or columns. These changes appear to reduce
 *  the amount of thrashing. Also, we use a "simulated annealing" approach,
 *  which requires that we sometimes keep a key that has a worst value.
 *  These ideas are due to J.W. Stumpel, who has a nice webpage and some
 *  downloadable code.
 *  REFERENCE: http://www.jw-stumpel.nl/playfair.html

 *  Stumpel just uses a table of relative digram frequencies. But I think
 *  it should still work with our book.txt. No?
 *  
 */

package hcrypto.analyzer;

import hcrypto.cipher.*;
import hcrypto.provider.*;

public class PlayfairNgramDecrypter extends NgramDecrypter{

    private int dfreq[][] = new int[26][26];
    private int digstat[][] = {
 	                         // j
	{7,11,11,12, 6,10,11,10,12, 0, 10,13,11,14, 6,11, 5,13,13,13, 9,11,10, 5,11, 7},      // a
	{10, 8, 5, 5,12, 4, 3, 6, 9,0, 3,11, 5, 4,11, 3, 2,10, 9, 8,11, 4, 6, 0,10, 1},// b
	{11, 4, 8, 5,12, 3, 4,12,10,0, 11,10, 4, 3,12, 4, 5,10, 6,10,10, 3, 5, 0, 7, 3},  // c
	{12,10, 9,10,12,10, 9,11,12,0,  6,10,10,10,11, 9, 6,10,11,12, 9, 8,10, 1,10, 1},  // d
	{13,11,12,13,12,11,11,11,12,0,  8,12,12,13,11,11, 9,14,13,13, 9,11,12,10,11, 6},  // e
	{11, 8, 8, 7,11,10, 7, 9,11,0,  4,10, 8, 7,12, 7, 4,11, 9,12,10, 6, 8, 1, 8, 1},  // f
	{11, 8, 8, 7,11, 8, 8,11,10,0,  4,10, 8, 9,11, 7, 4,10,10,11, 9, 6, 9, 0, 7, 1},  // g
	{13, 8, 7, 7,15, 7, 6, 9,13,0, 4, 8, 8, 7,12, 7, 4, 9, 9,11, 9, 5, 8, 0, 9, 0},  // h
	{10, 9,11,11,11,10,11, 8, 7,0,  9,12,11,14,11,10, 5,11,13,13, 8,10, 8, 7, 2, 8},  // i
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},// j
	{9, 7, 6, 6,11, 7, 5, 7,10, 0, 4, 8, 6, 9, 8, 5, 3, 5, 9, 8, 6, 3, 8, 0, 7, 0},   // k
	{12, 9, 8,11,13,10, 7, 9,12,0,  8,12, 9, 7,12, 8, 4, 8,10,10, 9, 8, 9, 0,12, 2},  // l
	{12, 9, 6, 6,12, 7, 5, 8,11,0,  3, 7, 9, 7,11,10, 4, 8,10,10,10, 4, 9, 0,10, 0},  // m
	{12, 9,11,13,12, 9,13,10,11,0, 10,10, 9, 9,12, 9, 7, 8,12,13, 9, 8,10, 5,10, 3},  // n
	{11,10,10,11, 9,13, 9,10,10,0, 10,11,12,13,12,10, 5,13,11,12,13,10,12, 5, 9, 5},  // o
	{11, 6, 5, 5,12, 6, 4, 9,10,0,  4,10, 6, 4,11,10, 3,11, 9,10, 9, 2, 7, 0, 7, 0},  // p
	{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10, 0, 0, 0, 0, 0},   // q
	{12,10,10,11,13, 9, 9,10,12,0,  9,10,11,10,12,10, 6,10,12,12,10, 9,10, 4,11, 3},  // r
	{12,10,11, 9,13,10, 8,12,12,0,  9,10,10,10,12,11, 7, 9,12,13,11, 7,11, 1, 9, 2},  // s
	{12,10,10, 9,13, 9, 8,15,13,0,  7,11,10, 9,13, 9, 6,11,12,12,11, 7,11, 2,10, 3},  // t 
	{9, 9,10, 9,10, 7,10, 7, 9, 0, 7,11,10,11, 8,10, 3,12,12,12, 4, 5, 8, 3, 5, 4},   // u
	{9, 0, 0, 0,12, 0, 0, 1,10, 0, 1, 1, 0, 2, 9, 0, 0, 2, 1, 3, 4, 0, 1, 0, 5, 0},   // v
	{12, 7, 7, 7,11, 7, 5,12,12, 0, 5, 8, 7,10,11, 6, 3, 8, 9, 9, 5, 4, 7, 0, 7, 3},  // w 
	{7, 2, 7, 2, 7, 3, 2, 5, 7, 0, 1, 2, 4, 2, 4, 8, 1, 3, 5, 8, 3, 2, 3, 4, 3, 0},   // x
	{10, 9, 9, 9,11, 9, 8, 9,10,0,  6, 9, 9, 8,11, 9, 5, 9,11,11, 7, 6,10, 0, 7, 2},  // y
	{5, 2, 0, 1, 8, 1, 0, 1, 6, 0, 0, 4, 1, 0, 6, 0, 0, 0, 1, 1, 3, 0, 0, 0, 4, 5}    // z
    };

    private static int KEYSIZE = 25;
    private static int MAXKEYWORD = 8;
    private static int MAX_ITERATIONS = 4000;
    private final boolean INNER_LOOP = true;
    private final boolean OUTER_LOOP = false;

    private int key[];                      // For Playfair cipher key is array of ints
    private int bestkey[];
    private int saved_key[];
    private Cipher cipher;                  // Used for creating cipher decrypt engine
    private HistoricalKey historicalKey;
    private int alphSize;
    private int randSize;
    private int keysize;                // Number of letters in the key
    private int keywdsize;                // Number of letters in the keyword
    private int gotworse;
    private double temperature;
    private float bestvalue;
    private float currvalue;
    
    private int j = 0, k = 0;               // Climber control variables
    private int jj = 0, kk = 0;
    private int unswap_j = 0, unswap_k = 0;
    private int unswap_jj = 0, unswap_kk = 0;
    private int iterations = 0;
    private int counters[] = {0,0,0,0,0,0,0,0,0};

    public PlayfairNgramDecrypter(String crypto, Alphabet alpha, NgramArray nga) {
	Provider.addProvider(new DefaultProvider("Default"));
	cipher = Cipher.getInstance("Playfair", "Default");
	historicalKey = HistoricalKey.getInstance(cipher.getAlgorithm(), cipher.getProvider());
	this.alphabet = alpha;
	alphSize = alphabet.getSize();
	this.cryptoText = crypto;
	System.out.println("Playfair " + cryptoText);
	this.cipherType = NgramAnalyzer.PLAYFAIR;
	this.ngramArr = nga;
	init();
	try {
	    runAnnealer();
	} catch (Exception e) {
	    
	}
    }


    public void runAnnealer()  throws Exception {
	int iterations = 0;
	int improved = 0;
	temperature = 0.04;
	key = getRandomKey();            // generate_firstkey ();
	String plain = decrypt();        //  decode (&mysquare);
	//	String plain = decipher(key); // decrypt();        //  decode (&mysquare);
	//	float currval = 1000 - currentEval();   // float currval = measure(plain); //  measure (&mysquare);
	float currval = measure(plain); //  measure (&mysquare);
	System.out.println("Current value = " + currval);
	copy(key, bestkey);             // champion = mysquare;
	float bestval = currval;
	while (true)  {
	    ++iterations;
	    copy(bestkey, key);   //      mysquare = champion;
	    currval = bestval;
	    //	    plain = decipher(key); // decrypt();    //      decode (&mysquare);
	    plain = decrypt();    //      decode (&mysquare);
	    System.out.println("\nCurrent value = " + currval);
	    System.out.println(getPlainText());  //         display_solution ();
	    System.out.println("Temperature = " + temperature);  //      printf ("Temperature: %f\n", T);

	    improved = 0;
	    for (int j = 0; j < 4000; j++) {
		int rand = (int)(Math.random() * 1000);  // a number between 0...999
		if (rand < 3) {
		    ++counters[0];
		    flip8(key);
		    //	    System.out.println("flip8");
		}
		else if (rand < 6) {
		    ++counters[1];
		    flip5(key);
		    //	    System.out.println("flip5");
		}
		else if (rand < 9) {
		    ++counters[2];
		    flip7(key);	
		    //	    System.out.println("flip7");
		}
		else if (rand < 15) {
		    ++counters[3];
		    turncol(key);
		    //	    System.out.println("turncol");
		}
		else if (rand < 21) {
		    ++counters[4];
		    turnrow(key);
		    //	    System.out.println("turnrow");
		}
		else if (rand < 200) {
		    ++counters[5];
		    exchange_rows(key);
		    //	    System.out.println("exchange rows");
		}
		else if (rand < 400) {
		    ++counters[6];
		    exchange_cols(key);
		    //	    System.out.println("exchange cols");
		}
		else if (rand < 600) {
		    ++counters[7];
		    stir(key, 1);        // Swap two letters
		    //	    System.out.println("stir 1");
		}
		else if (rand >= 850) {
		    ++counters[8];
		    stir3(key);
		    //	    System.out.println("stir 3");
		}
		else {
		    ++counters[7];
		    stir(key, 1);
		    //	    System.out.println("stir 1");
		}
	    

		plain = decrypt();        //  decode (&mysquare);
		//		plain = decipher(key); // decrypt();        //  decode (&mysquare);
		//		currval = 1000 - currentEval();   // float currval = measure(plain); //  measure (&mysquare);
		currval  = measure(plain); //  measure (&mysquare);

		float diff = currval - bestval;      // mysquare.score - champion.score;

		if (diff > 0)
		    improved++;

		double val1 = (float)Math.random();
		double val2 = Math.exp(diff/temperature);
			
		//	  if (diff > 0 || ((float) rand () / RAND_MAX < exp (diff / T))) {

		if (diff > 0 || val1 < val2) {
		    copy(key, bestkey);       //		champion = mysquare;
		    bestval = currval;
		    //	      printf("* %7.4f %7.4f %7.4d", val1, val2, RAND_MAX); 
		}
		else {
		    copy(bestkey, key);
		    currval = bestval;	//	mysquare = champion;
		}
	    
		if (improved > 50) {
		    System.out.println("Breaking improved enough after " + j + " iterations"); 
		    break;
		}
		
	    } // for j 1...4000
	
	    temperature *= 0.98;
	    if (improved == 0) {
		System.out.println("Breaking. No improvement. Iterations = " + iterations + "\n"); 
		//		break;
		System.exit(0);
		
	    }
	} // while (true)
    }
    
    private String decipher (int key[]) {
	
	int row[] = new int[26];
        int col[] = new int[26];
	int c0, c1, p0, p1;

	for (int j = 0; j < 25; j++)   {
	    row[key[j]] = j / 5;
	    col[key[j]] = j % 5;
	}

	//	System.out.println("\nDeciphering " + cryptoText.length() + " " + cryptoText + "\n");

	StringBuffer sb = new StringBuffer();

	for (int k = 0; k < cryptoText.length()-1; k += 2) {
	    c0 = cryptoText.charAt(k) - 'a';
	    c1 = cryptoText.charAt(k+1) - 'a';
	    
	    if (row[c0] == row[c1]) {
		p0 = col[c0] != 0 ? key[5 * row[c0] + col[c0] - 1]
		    : key[5 * row[c0] + 4];
		p1 = col[c1] != 0 ? key[5 * row[c1] + col[c1] - 1]
		    : key[5 * row[c1] + 4];
	    }
	    else if (col[c0] == col[c1]) {
		p0 = row[c0] != 0 ? key[5 * (row[c0] - 1) + col[c0]]
		    : key[20 + col[c0]];
		p1 = row[c1] != 0 ? key[5 * (row[c1] - 1) + col[c1]]
		    : key[20 + col[c1]];
	    }
	    else {
		p0 = key[5 * row[c0] + col[c1]];
		p1 = key[5 * row[c1] + col[c0]];
	    }
	    //	    System.out.println(c0 + " " + c1 + " " + p0 + " "  + p1);
	    sb.append((char)(p0 + 'a'));
	    sb.append((char)(p1 + 'a'));
	}
	
	//	System.out.println("\n" + sb.toString());
	
	return sb.toString();
	
    }

    /*********** The following are abstract in the super class. ********/

    public String getPlainText() throws Exception {
	//	return decrypt(cryptoText, bestkey, alphabet);
	//	System.out.println("Measure = " + measure(decrypt()));
	return decrypt(cryptoText, bestkey, alphabet) + "  (" + keywdsize + ") "+  intarrToChars(bestkey);
    }

    public String decrypt() throws Exception {
	return decrypt(cryptoText, key, alphabet);
    }

    public void randomizeClimb() {
	copy(bestkey,key);
	currvalue = bestvalue;
	
	iterations = 0;
	gotworse = 0;
	temperature *= 0.98;
	System.out.println("Temperature = " + temperature);
	
	for(int k = 0; k < counters.length; k++) {
	    System.out.print(counters[k] + " ");
	    counters[k] = 0;
	}
	System.out.println();
/*************
	if (Math.random() < 0.75) {
	    stir(key,10);
	    System.out.println(" Stirred");
	}
	else System.out.println();
	*****************/
    }

    public void initClimb() {
	//	iterations = 0;
    }

    public void climb() {
	iterations++;
	int rand = (int)(Math.random() * 1000);  // a number between 0...999
	if (rand < 3) {
	    ++counters[0];
	    flip8(key);
	    //	    System.out.println("flip8");
	}
	else if (rand < 6) {
	    ++counters[1];
	    flip5(key);
	    //	    System.out.println("flip5");
	}
	else if (rand < 9) {
	    ++counters[2];
	    flip7(key);	
	    //	    System.out.println("flip7");
	}
	else if (rand < 15) {
	    ++counters[3];
	    turncol(key);
	    //	    System.out.println("turncol");
	}
	else if (rand < 21) {
	    ++counters[4];
	    turnrow(key);
	    //	    System.out.println("turnrow");
	}
	else if (rand < 200) {
	    ++counters[5];
	    exchange_rows(key);
	    //	    System.out.println("exchange rows");
	}
	else if (rand < 400) {
	    ++counters[6];
	    exchange_cols(key);
	    //	    System.out.println("exchange cols");
	}
	else if (rand < 600) {
	    ++counters[7];
	    stir(key, 1);        // Swap two letters
	    //	    System.out.println("stir 1");
	}
	else if (rand >= 850) {
	    ++counters[8];
	    stir3(key);
	    //	    System.out.println("stir 3");
	}
	else {
	    ++counters[7];
	    stir(key, 1);
	    //	    System.out.println("stir 1");
	}

	if (!isValidPlayfair(key)) {
	    System.out.println("****************INVALID KEY: " + j + " " + k + " " + intarrToChars(key) );
	}
    }

    public void undostep() {
	++gotworse;
	//	double diff = currvalue - bestvalue;
	double diff = bestvalue - currvalue;
	if (Math.random() >= Math.exp( diff / temperature)) {
	    //	if (Math.random() < 0.9)
	    copy(bestkey,key);
	    currvalue = bestvalue;
	}
	else {
	    copy(key, bestkey);
	    bestvalue = currvalue;
	    if (diff == 0)
		System.out.print("#"); // Keep the lesser key
	    else
		System.out.print("*"); // Keep the lesser key
	}
    }

    public boolean hasMoreHill() {
	int gotbetter = iterations - gotworse;
	//	System.out.println("Improvements = " + gotbetter);
	
	if (gotbetter >= 50) {
	    System.out.println("************** Reached 50 improvements exiting **********");
	    return false;
	}

	if (iterations >= MAX_ITERATIONS && gotbetter == 0) {
	    System.out.println("\nNo Improvement: exiting");
	    System.exit(0);
	}
	
	return iterations < MAX_ITERATIONS;
    }

    /* 
       NOTE: The following six functions are copied from Stumpel's algorithm,
       a simulated annealing hill-climber. They are used to improve the
       convergence of the hillclimber by allowing it to take smaller steps.
       See: http://www.jw-stumpel.nl/playfair.html
    */

    /*flip the whole keysquare, exchanging rows and columns */
    private void flip8(int arr[]) 
    {
	int i, j;
	int tempsquare[] = new int[arr.length];
	for (i = 0; i < 5; i++)
	    for (j = 0; j < 5; j++)
		tempsquare[i + 5 * j] = arr[5 * i + j];
	copy(tempsquare,arr);
	//	arr = tempsquare;
    }

    /*flip the whole keysquare, exchanging top and bottom */
    private void flip5 (int arr[])
    {
	int i, j;
	int tempsquare[] = new int[arr.length];
	for (i = 0; i < 5; i++)
	    for (j = 0; j < 5; j++)
		tempsquare[i + 5 * j] = arr[i + 5 * (4 - j)];
	copy(tempsquare,arr);
	//	arr = tempsquare;
    }

    /*flip the whole keysquare, exchanging left and right */
    private void flip7 (int arr[])
    {
	int i, j;
	int tempsquare[] = new int[arr.length];
	for (i = 0; i < 5; i++)
	    for (j = 0; j < 5; j++)
		tempsquare[i + 5 * j] = arr[(4 - i) + 5 * j];
	copy(tempsquare,arr);
	//	arr = tempsquare;
    }


    /*flip the whole keysquare, exchanging left and right, AND top and bottom */
    private void flip6 (int arr[])
    {
	int i, j;
	int tempsquare[] = new int[arr.length];
	for (i = 0; i < 5; i++)
	    for (j = 0; j < 5; j++)
		tempsquare[i + 5 * j] = arr[(4 - i) + 5 * (4 - j)];
	copy(tempsquare,arr);
	//	arr = tempsquare;
    }

    /* exchange 2 random rows in keysquare */
    private void exchange_rows (int arr[])
    {
	int temp;
	int j, rowa, rowb;
	rowa = (int)(Math.random() * 5);
	do {
	    rowb = (int)(Math.random() * 5);
	} while (rowb == rowa);

	for (j = 0; j < 5; j++)    {
	    temp = arr[5 * rowa + j];
	    arr[5 * rowa + j] = arr[5 * rowb + j];
	    arr[5 * rowb + j] = temp;
	}
    }

    /* exchange 2 random cols in keysquare */
    private void exchange_cols (int arr[])    {
	int temp;
	int j, cola, colb;
	cola = (int)(Math.random() * 5);
	do {
	    colb = (int)(Math.random() * 5);
	}  while (colb == cola);
	for (j = 0; j < 5; j++)  {
	    temp = arr[5 * j + cola];
	    arr[5 * j + cola] = arr[5 * j + colb];
	    arr[5 * j + colb] = temp;
	}
    }

    private void turnrow (int arr[])    {
	int temp, j, k = (int)(Math.random() * 5);
	for (j = 0; j < 2; j++)  {
	    temp = arr[k + 5 * j];
	    arr[k + 5 * j] = arr[k + 5 * (4 - j)];
	    arr[k + 5 * (4 - j)] = temp;
	}
    }


    private void turncol (int arr[]) {
	int temp, j, k = (int)(Math.random() * 5);
	for (j = 0; j < 2; j++) {
	    temp = arr[5 * k + j];
	    arr[5 * k + j] = arr[5 * k + (4 - j)];
	    arr[5 * k + (4 - j)] = temp;
	}
    }


    /* this stirs up the brew by exchanging n random key pairs */
    private void stir (int arr[], int n) {
	int i, j;
	int temp;
	if (n < 0)
	    return;
	while (n > 0) {
	    i = (int)(Math.random() * 25);
	    do {
		j = (int)(Math.random() * 25);
	    } while (j == i);

	    temp = arr[i];
	    arr[i] = arr[j];
	    arr[j] = temp;
	    n--;
	}
    }

    /* makes a random 3-swap in the keysquare */
    private void stir3 (int arr[]) {
	int i, j, k;
	int temp;
	i = (int)(Math.random () * 25);
	do {
	    j = (int)(Math.random() * 25);
	} while (j == i);
	do {
	    k = (int)(Math.random() * 25);
        }  while ((k == i) || (k == j));

	temp = arr[i];
	arr[i] = arr[j];
	arr[j] = arr[k];
	arr[k] = temp;
    }

    private boolean isValidPlayfair(int arr[]) {
	for (int k = keywdsize; k < arr.length-1; k++)
	    if ((arr[k]  >= arr[k+1]))
		return false;
	return true;
    }

    public int getCipherType() {
	return cipherType;
    }

    public void saveState() {
	bestkey = new int[key.length];
	copy(key, bestkey);
	bestvalue = currvalue;
    }

    private float measure (String s) {
	//	int i, j, n = 1, *p = pbuf;
	//	System.out.println(s.length() + " Last two chars = " + s.charAt(s.length()-2) + " " + s.charAt(s.length()-1));
	int i, j, n = 0;
	int p = 0;                      // pointer into the string s 
	long digvalue = 0;		/* this has to hold rather big integers. */

	j = s.charAt(0) - 'a';  ;
	for (int k = 1; k < s.length()-1; k++) {
	    i = j;
	    j = s.charAt(k) - 'a';
	    //	    System.out.println(i + " " + j + " " + k + " " + s.charAt(k));
	    dfreq[i][j]++;
	}

	for (i = 0; i < 26; i++)
	    for (j = 0; j < 26; j++) {
		n = dfreq[i][j];
		if (n > 0) {
	    //		    System.out.println(i + " " + j);
		    digvalue += n * digstat[i][j];
		    dfreq[i][j] = 0;
		}
	    }
	return (float) (1.0 * digvalue / s.length());

    }

    private float currentEval(String s) throws Exception {
	//	currvalue = ngramArr.recipDist(s);
	currvalue = 20 - measure(s);
	return currvalue;
    }

    public float currentEval() throws Exception {
	//	currvalue = 20 - measure(decrypt());
	currvalue = ngramArr.recipDist(decrypt());
	//	System.out.println("Result= " + currvalue);
	//	System.out.println("Best Score = " + measure(decrypt()));
	return currvalue;
    }

    public float bestEval() throws Exception {
	bestvalue = ngramArr.recipDist(getPlainText());
	//	return bestvalue;
	return (float)1000;
    }

    protected void playfair_swap(int arr[], int j, int k, boolean inner) {
	//	swap(arr, j, k);   // Just calls the default swap

	try {
	    //	System.out.println("Swap j= " + (char)('a'+arr[j]) + " k= " + (char)('a'+arr[k]) + " Key = " + intarrToChars(arr));
	    if (j < keywdsize && k < keywdsize) {
		int temp = arr[j];
		arr[j] = arr[k];
		arr[k] = temp;
		if (inner) {
		    unswap_jj = j;
		    unswap_kk = k;
		} else {
		    unswap_j = j;
		    unswap_k = k;
		}
		return;
	    }
	    int temp = arr[j];           // Save j for later insertion
	    arr[j] = arr[k];             // Insert k in j's location, k is insertion point

	// Find j's insertion point
	    while (k < arr.length-1 && temp > arr[k+1] ) { // Shift letters down
		arr[k] = arr[k+1];
		k++;
	    }
	    while (k > keywdsize && temp < arr[k-1]) { // Shift letters up
		arr[k] = arr[k-1];
		k--;
	    }
	    arr[k] = temp;
	    if (inner) {
		unswap_jj = j;
		unswap_kk = k;
	    } else {
		unswap_j = j;
		unswap_k = k;
	    }
//	System.out.println("Result = (" + keywdsize + ") " + intarrToChars(arr) + " " + currentEval(decrypt(cryptoText, arr, alphabet)));
//	System.out.println("Result         Key = " + intarrToChars(arr) + " " + currentEval(decrypt(cryptoText, arr, alphabet)));
	} catch (Exception e) {
	    System.out.println("Swap Exception " + j + " " + k);
	    e.printStackTrace();
	    System.exit(0);
	}
    }

    /*************** Private utility methods. ****************/

    private int[] getRandomKey() {
	keywdsize++;
	if (keywdsize > keysize-1) 
	    keywdsize = 2;
	//	keywdsize=9;
	keywdsize=KEYSIZE;
	//	System.out.println("Trying keywdsize = " + keywdsize);


	int key[] = null;
       	keysize = KEYSIZE;
	key = new int[keysize];
	int k = 0;
	for (int m = 0; m < key.length; m++) {    // Init keyword arrays
	    if (k == 9)                    // Skip 'j'
		k++;
	    key[m] = k;
	    ++k;
	} //for

/*******************
	//	keywdsize = 9;
	//        String testkey = "morelipsyabcdfghknqtuvwxz";
	String testkey = "ctorhalugbmfspdwxyzqevink";
	for (k = 0; k < key.length; k++)
	    key[k] = testkey.charAt(k) - 'a';
********************/
	try {
	//	System.out.println("Initialkey= (" + keywdsize + ") " + intarrToChars(key));
	randomize_playfair(key, key.length, keywdsize); 

	    //	    String decrypt = decrypt(cryptoText, key, alphabet);
	    //	    System.out.println("Initial Key = (" + keywdsize + ") " + intarrToChars(key) + " " + currentEval(decrypt) + " " + decrypt);
	    //	    randomize_playfair(key, key.length, keywdsize, key.length); 

	//	    System.out.println("Randomkey= (" + keywdsize + ") " + intarrToChars(key) + " " + currentEval(decrypt(cryptoText, key, alphabet)));
	//	    System.out.println("Decrypt= " + decrypt(cryptoText,key,alphabet));
	} catch (Exception e) {
	}
//	if (!isValidPlayfair(key)) 
//	    System.out.println("******** GETRANDOMKEY INVALID KEY: " + j + " " + k + " " + intarrToChars(key) );

	return key;
    }

    private void randomize_playfair(int key[], int keylen, int keywdlen) {
	int m;
	//        for (int k = 0; k < keywdlen; k++) {
	//            m = keywdlen + (int)(Math.random() * (keylen-keywdlen));
	//        for (int k = 0; k < keylen; k++) {
        for (int k = 0; k < keywdsize; k++) {
            m = (int)(Math.random() * keylen);
	    //	    System.out.println("******** RANDOMIZE            : " + k + " " + m + " " + intarrToChars(key) );
	    if (m != k)
		playfair_swap(key, Math.min(k, m), Math.max(k,m), INNER_LOOP);
	    //	    if (!isValidPlayfair(key)) 
	    //		System.out.println("******** RANDOMIZE INVALID KEY: " + k + " " + m + " " + intarrToChars(key) );
        } //for

    }

    private void randomize_playfair(int key[], int keylen, int keywdlen, int N) throws Exception {
	int m,n;
        for (int k = 0; k < N; k++) {
	    flip5(key);
	    //	    n = (int)(Math.random() * keywdlen);
	    //            m = (int)(Math.random() * keylen);
	    //	    System.out.println("******** RANDOMIZE            : " + k + " " + m + " " + intarrToChars(key) );
	    //	    if (m != n)
	    //		playfair_swap(key, Math.min(n, m), Math.max(n,m), INNER_LOOP);
	    try {
		//		System.out.println("k= " + k + " n= " + n + " m= " + m + " " + intarrToChars(key) + " " + currentEval(decrypt(cryptoText, key, alphabet)) );
		System.out.println("k= " + k + " " + intarrToChars(key) + " " + currentEval(decrypt(cryptoText, key, alphabet)) );
	    } catch (Exception e) {
	    }
	    //	    if (!isValidPlayfair(key)) 
	    //		System.out.println("******** RANDOMIZE INVALID KEY: " + k + " " + m + " " + intarrToChars(key) );
        } //for

    }

    private String decrypt(String cText, int[] key, Alphabet alpha) throws Exception {
	String keyword;
	keyword = intarrToChars(key);
	//	System.out.println("Playfair keyword= " + keyword);
	historicalKey.init(keyword, alpha, alpha);
	//	historicalKey.init("morel", alpha, alpha);
	cipher.init(historicalKey);
	String decrypt = cipher.decrypt(cText);
	//	System.out.println("Decrypt= " + decrypt);
	return decrypt;
    }

    private void init() {
	randSize = 26;
	keywdsize = 1;
	keysize = KEYSIZE;
	System.out.println("alphasize= " + alphSize + " randSize= " + randSize);

	key = getRandomKey();
	bestkey = new int[key.length];
	copy(key, bestkey);
	saved_key = new int[key.length];
	copy(key, saved_key);
	iterations = 0;
	temperature = (float)0.04;
    }
}
