package hcrypto.analyzer;

import hcrypto.cipher.*;
import hcrypto.provider.*;

public class SubstitutionNgramDecrypter extends NgramDecrypter{

    private int randSize; // Randomize the first randSize chars of alphabet.
    private boolean dontRandomize = false;
    private int alphSize; // The size of the alphabet.
    private int cnumsSize; // The number of alphabet chars in cryptoText.
    private int[] cryptoCnums; // Stores the int array of cryptoText.
    private int[] bestCnums; // Stores the int array of current best solution.
    private int[] bestGlobalCnums; // Stores the int array of current best ever solution.
    private int[] bestDecrypt; //Decrypting substitution for best plaintext.
    private int[] bestGlobalDecrypt; //Decrypting substitution for best ever plaintext.
    private int[] testCnums = new int[cnumsSize];  //Allocate memory for local variables.
    private int[] decryptKey = new int[alphSize];  // Integer version of the key

    private int j = 0, k = 0;               // Climber control variables

    public SubstitutionNgramDecrypter(String crypto, Alphabet alpha, NgramArray nga) throws Exception {
	this.alphabet = alpha;
	alphSize = alphabet.getSize();
	this.cryptoText = crypto;
	this.cipherType = SIMPLESUB;
	this.ngramArr = nga;
	init();
    }

    public void setRandSize(int n) {
	randSize = n;
    }

    public String getBestGlobalPlaintext() throws Exception {
	decryptCnums(cryptoCnums, bestGlobalDecrypt, bestGlobalCnums);
	return decryptString(cryptoText, bestGlobalDecrypt);
    }

    /************ These methods are abstract in the superclass ********/


    public String getPlainText() throws Exception {
	decryptCnums(cryptoCnums, bestDecrypt, bestCnums);
	return decryptString(cryptoText, bestDecrypt);
	//	return decryptString(cryptoText, bestDecrypt) + "\nKey:|" + intarrToChars(bestDecrypt) + "|\n";
    }

    public String decrypt() throws Exception {
	decryptCnums(cryptoCnums, decryptKey, testCnums);
	return decryptString(cryptoText, decryptKey);
    }

    public void randomizeClimb() {
	if (!dontRandomize) {
	    randomize(decryptKey, randSize);
	}
    }

    public void swapInKey(int m, int n) { 
	//	System.out.println(intarrToChars(decryptKey) + " " + m + " " + n);
	swap(decryptKey, m, n);
	//	System.out.println(intarrToChars(decryptKey) + " " + m + " " + n);
    }

    /**
     * randomize() randomly transposes the first N elements of
     *  an int array.
     */
    protected void randomize(int key[], int N) {
	/*******
	//	String s="bcdfghijklmnpquvwxyzoraste";
	//	String s="abcdefghijklmnopqrstuvwxyz";
	for (int k = 0; k < s.length(); k++) {
	    key[k] = s.charAt(k)-'a';
	}
	copy(key,decryptKey);
	    try {
		System.out.println("Initial key: " + intarrToChars(key) + " " + currentEval() );
	    } catch (Exception e) {
	    }
	************/


        int m;
        for (int k = 0; k < N; k++) {
            m = (int)(Math.random() * N);
	    swap(key, k, m);
	    /************
	    try {
		//	System.out.println("Initial Decrypt: " + decrypt());
		//		System.out.println("k= " + k + " m= " + m + " " + intarrToChars(key) + " " + currentEval() );
	    } catch (Exception e) {
	    }
	    **************/
        } //for
    }

    public void initClimb() {
	j = 0;
	k = 1;
    }

    public void climb() {
	swap(decryptKey, j, k);
    }

    public void undostep() {
	swap(decryptKey, j, k);
	j++;
	if (j >= k) { j = 0; k++; }
    }

    public boolean hasMoreHill() {
	return k < randSize;
    }

    public int getCipherType() {
	return cipherType;
    }

    public String getDecryptKey() {
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < decryptKey.length; k++) 
	    sb.append((char)('a' + decryptKey[k]));
	return sb.toString();
    }

    public String getBestKey() {
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < bestDecrypt.length; k++) 
	    sb.append((char)('a' + bestDecrypt[k]));
	return sb.toString();
    }

    public void saveBestGlobalState() {
	bestGlobalDecrypt = new int[decryptKey.length];
	copy(decryptKey, bestGlobalDecrypt);
    }

    public void saveState() {
	bestDecrypt = new int[decryptKey.length];
	copy(decryptKey, bestDecrypt);
    }

    public double currentEval() throws Exception {
	decryptCnums(cryptoCnums, decryptKey, testCnums);
	String testText = decryptString(cryptoText, decryptKey);
	//	System.out.println(intarrToChars(decryptKey));
	return ngramArr.recipDist(testText);   // Various eval functions can be used
	//	return ngramArr.absDiffBigramDist(testText);   // Clark's function bigrams only
	//	return ngramArr.recipDist(testCnums);
    }

    public double bestEval() throws Exception {
	decryptCnums(cryptoCnums, bestDecrypt, bestCnums);
	String testText = decryptString(cryptoText, bestDecrypt);
	return ngramArr.recipDist(testText);  // Various eval functions can be used
	//	return ngramArr.absDiffBigramDist(testText);  // Clark's function bigrams only
	//	return ngramArr.recipDist(bestDecrypt);
    }

    /****************** Private utility methods. *********************/

    private void init() throws Exception {
	randSize = 26;
	//	System.out.println("alphasize= " + alphSize + " randSize= " + randSize);
	int chNum = 0;  //for use in loops
	int m; //loop variables

	int len = cryptoText.length();  //Calc the num chars of cryptoText in alphabet
	for (m = 0; m < len; m++)
            if (alphabet.isInAlphabet(cryptoText.charAt(m))) chNum++;
	cnumsSize = chNum;  //Assign instance variable

	cryptoCnums = new int[cnumsSize];  //allocate memory for instance variable
	chNum = 0;    //Translate cryptoText to array of ints cryptoCnums
	for (m = 0; m < len; m++)
            if (alphabet.isInAlphabet(cryptoText.charAt(m))){
                cryptoCnums[chNum] = alphabet.charToInt(cryptoText.charAt(m));
                chNum++;
            } //if

	bestCnums = new int[cnumsSize];  //Allocate memory for instance variables.
	bestGlobalCnums = new int[cnumsSize];  //Allocate memory for instance variables.
	bestDecrypt = new int[alphSize];
	bestGlobalDecrypt = new int[alphSize];

	testCnums = new int[cnumsSize];  //Allocate memory for local variables.
	decryptKey = new int[alphSize];
	for (m = 0; m < alphSize; m++){    //init substitution arrays
            bestDecrypt[m] = m;
            decryptKey[m] = m;
	}//for
    }

    /**
     * allows the substitution key to be initialized to a
     *  specific alphabet rather than to a random one.
     *  Introduced for hard Alberti.
     */
    public void setDecryptKey(String s) {
	if (s.length() <= decryptKey.length) {
	    for (int k = 0; k < s.length(); k++)
		decryptKey[k] = s.charAt(k) - 'a';
	    dontRandomize = true;
	}
    }


   /*
    * decryptCnums(inCnums,aDecrypt,outCnums) applies the substitution
    * aDecrypt to inCnums and copies it to outCnums
    */
    private void decryptCnums(int[] inCnums, int[] aDecrypt, int[] outCnums) {
        for (int k = 0; k < inCnums.length; k++)
              outCnums[k] = aDecrypt[inCnums[k]];
    } //decryptCnums()

     /**
      * decryptString(String inText, int[] decryptArr)
      * to the elements of the array arr2.  It is assumed that the arrays
      * have been constructed and are of the same size.
      */
    private String decryptString(String inText, int[] decryptArr) throws Exception {
         StringBuffer sb = new StringBuffer();

         char ch;
         int x;
         int len = inText.length();
         try{
           for (int k = 0; k < len; k++){
             ch = inText.charAt(k);
             if (alphabet.isInAlphabet(ch)){
                x = alphabet.charToInt(ch);
                sb.append(alphabet.intToChar(decryptArr[x]));
             } //if
             else {
                sb.append(ch);
             } //else
            } //for
         } //try
         catch(Exception exc){
            System.out.println("In NgramClimber DecryptString -" + exc.toString());
         } //catch
         return sb.toString();
     } //decryptString()


}
