package hcrypto.analyzer;

import hcrypto.analyzer.*;

public class Token implements Comparable {

    private String token;
    private String pattern;
    private int score;
    private String[] patternSet;
    private PatternDictionary eval_dict;

    public Token(String s) {
        token = new String(s);
        pattern = new String(TextUtilities.makePattern(s));
        score = computeScore(pattern);
    }

    public Token(String s, PatternDictionary dict) {
	eval_dict = dict;
        token = new String(s);
        pattern = new String(eval_dict.makePattern(s));
        score = computeScore(pattern);
	patternSet = dict.getPatternWordArray(token);
//	System.out.println("Pattern set for " + token);
//	for (int k = 0; patternSet != null && k < patternSet.length; k++) 
//	    System.out.println(patternSet[k]);
    }


    public String getToken() {
        return token;
    }

    public String getPattern() {
        return pattern;
    }


    public String[] getPatternSet() {
        return patternSet;
    }

    public int getScore() {
        return score;
    }

    private int computeScore(String s){
        int count = eval_dict.countWordsForPattern(s);
        if (count == 0)
	    return Integer.MAX_VALUE;      // We want to skip these words
        return count;
    }

    /**
     * Sorts in ascending order
     */
    public int compareTo(Object o) {
        Token t = (Token)o;
        if (this.score < t.score)
	    return -1;
	else if (this.score > t.score)
	    return +1;
	else
	    return 0;
    }

}
