package hcrypto.analyzer; // This class in part of the TypeIVGaAnalyzer analyzer in hcrypto 

import hcrypto.cipher.*;
import hcrypto.engines.*;
import hcrypto.provider.*;

public class TypeIVGaIndividual extends GaIndividual implements Comparable
{
    private final boolean MUTATE_BENEFICIAL = true;  // Mutate only if beneficial
    private final char SPACE = ' ';
    private NgramArray ngramArr;
    private int NN;  // Ngram length = 2, 3, 4, ...
    //    private int index[] = new int[2];          // Stores location of max(worst) and min(best) nGram scores
    //    private double scores[]; // records the scores of individuals
    private int dividePos;
    private final char divide = ',';
    private int shiftLen;
    private String text;
    private LetterKeyMap shiftKeyMaps[];  // An array giving the locations of the E->? map for each ciphertext column

    public StringBuffer tempKey = new StringBuffer("zyxwvutsrqponmlkjihgfedcba");

    private String shiftKey;
    //    private StringBuffer permKey;

    Cipher cipher;
    private TypeIVKey typeIVKey;

    public TypeIVGaIndividual(String text, String permKey, String shiftKey, LetterKeyMap emaps[], GaParameters params, NgramArray nga)  {
	//	super(text, permKey + "," + shiftKey, params);
	super(text, permKey, params);
	this.text = text;
	//	this.permKey = new StringBuffer(permKey);
	this.shiftKey = shiftKey;
	this.shiftLen = shiftKey.length();
	shiftKeyMaps = emaps;
	ngramArr = nga;
	NN = ngramArr.getNN();
	mutate_policy = params.mutate_policy;

        // Create and register the provider classes
        Provider.addProvider(new DefaultProvider("Default")); 
        Provider.addProvider(new RamProvider("Ram")); 
        // Create an instance of the cipher and its corresponding key
        cipher = Cipher.getInstance("TypeIV", "Ram");
        typeIVKey = (TypeIVKey)HistoricalKey.getInstance(cipher.getAlgorithm(), cipher.getProvider());

        calcFitness();
    }

    /**
     * Copy constructor
     */
    public TypeIVGaIndividual (GaIndividual i) 
    {
	super(i);
	cipher = ((TypeIVGaIndividual)i).cipher;
	typeIVKey = ((TypeIVGaIndividual)i).typeIVKey;
        shiftKeyMaps = ((TypeIVGaIndividual)i).shiftKeyMaps;
	ngramArr = ((TypeIVGaIndividual)i).ngramArr;
	NN = ngramArr.getNN();
	shiftKey = ((TypeIVGaIndividual)i).shiftKey;
	//	permKey = ((TypeIVGaIndividual)i).permKey;
	this.text = ((TypeIVGaIndividual)i).text;
    }

    public boolean equals(Object i) {
	return fitness == ((TypeIVGaIndividual)i).fitness;
	//	StringBuffer iKey = ((TypeIVGaIndividual)i).key;
	//	for (int k = 0; k < key.length(); k++) 
	//	    if (key.charAt(k) != iKey.charAt(k))
	//		return false;
	//	return true;
    }


    /** 
     *  Two-point crossover: Pick random points in i1 and i2
     *   and swap a random number characters starting from those points.
     */
    public void cross(GaIndividual i) 
    {	TypeIVGaIndividual i1 = this;
	TypeIVGaIndividual i2 = (TypeIVGaIndividual)i;
	//	System.out.println("i1 befor: " + i1.getKey() + "\ni2 befor: " + i2.getKey());
	int p = (int)(Math.random() * key.length());
	//	int pstop = p + NN + 2;
	int step = 2 + (int)(Math.random() * 5);  // Length of segment to cross, 2-6 letters
	//	int step = NN;
	//	int step = 2;
	int pstop = p + step;
	int p2 = (int)(Math.random() * key.length());
	int p2stop = p2 + step;
	//	System.out.println("Swapping from " + p + " to " + pstop + " and " + p2 + " to " + p2stop);
	while (p < pstop && p < key.length() && p2 < p2stop && p2 < key.length()) 
	{
	    char ch1 = i1.key.charAt(p);
	    char ch2 = i2.key.charAt(p2);
	    i1.swap(ch1, ch2);
	    i2.swap(ch1, ch2);
	    p++;
	    p2++;
	}
	//	System.out.println("i1 after: " + i1.getKey());
	//	System.out.println("i2 after: " + i2.getKey());
	
	i1.calcFitness();  
	i2.calcFitness();
    }

    public boolean isLegal(String seedPairs) {
	return isLegal(key, seedPairs, shiftKeyMaps);
    }

    /**
     *  isLegal() -- a key is legal if it contains
     *   all of the seedPairs---don't break up a
     *   seedPair.
     */
    public static boolean isLegal(StringBuffer key, String seedPairs, LetterKeyMap[] shiftKeyMaps) {
	//	System.out.println(key.toString() + " " + seedPairs);
	boolean ok = true;
	//	/*****
	for (int k = 0; k < shiftKeyMaps.length; k++) {
	    String s = shiftKeyMaps[k].ch + "";
	    if (key.indexOf(s) != shiftKeyMaps[k].location)
		return false;
	}
	//	*********/
	//	return true;
	//	return key.indexOf("eg") == 0  && key.indexOf("s") == 8 ;
	//	return key.indexOf("eg") == 0 && key.indexOf("q") == 5  && key.indexOf("s") == 8 ;
	    //	return key.indexOf("eg") == 0 && key.indexOf("q") == 5  && key.indexOf("s") == 8 
	    //	&&    key.indexOf("v") == 11 && key.indexOf("c") == 20;
	///	/*******
	for (int k = 0; k < seedPairs.length() && ok; k += 2) {
	    String pair = seedPairs.substring(k, k+2);
	    //	    System.out.println("pair= " + pair);
	    ok = (key.indexOf(pair) != -1) || (pair.charAt(0) == key.charAt(key.length()-1) && pair.charAt(1) == key.charAt(0));
	}
	//	*******/
	return ok;
    }

    /** 
     *  One-point crossover: Pick random point in i1 and i2
     *   and swap a random number characters starting from those points.
     *  NOTE: This appears to converge too fast in TypeIII.
    public void cross(GaIndividual i) 
    {	TypeIVGaIndividual i1 = this;
	TypeIVGaIndividual i2 = (TypeIVGaIndividual)i;
	//	System.out.println("i1 befor: " + i1.getKey() + "\ni2 befor: " + i2.getKey());
	int p = (int)(Math.random() * key.length());
	int step = 2 + (int)(Math.random() * 5);  // Length of segment to cross, 2-6 letters
	int pstop = p + step;
	//	System.out.println("Swapping from " + p + " to " + pstop);
	while (p < pstop && p < key.length()) 
	{
	    char ch1 = i1.key.charAt(p);
	    char ch2 = i2.key.charAt(p);
	    i1.swap(ch1, ch2);
	    i2.swap(ch1, ch2);
	    p++;
	}
	//	System.out.println("i1 after: " + i1.getKey());
	//	System.out.println("i2 after: " + i2.getKey());
	
	i1.calcFitness();  
	i2.calcFitness();
    }
    ************************     */

    // 01234567890123456789012345
    // ABCDEFGHIJKLMNOPQRSTUVWXYZ

    protected void swap (char ch1, char ch2) {
	//	System.out.print("key " + key + " --> ");
        int m = key.toString().indexOf(ch1);
        int n = key.toString().indexOf(ch2);
        key.setCharAt(m, ch2);
        key.setCharAt(n, ch1);        
	//	System.out.println("Swap " + ch1 + " " + ch2 + " " + key);
    }

    /** 
     *  Two-point crossover with no collisions. First check that the
     *   two segments being crossed do not have any letters in common.
     *   If they do, slide one pointer to the left with wrap around to
     *   try and avoid the collision.   
     *  NOTE: This approach tends to converge too quickly on a local minimum.
     */
    public void crossNoCollision(GaIndividual i) {
	TypeIVGaIndividual i1 = this;
	TypeIVGaIndividual i2 = (TypeIVGaIndividual)i;
	int p = (int)(Math.random() * (key.length()-2));   // Minimum length is 2 
	int len = 2 + (int)(Math.random() * Math.min(5,key.length()-p-1));  // Length of segment to cross, 2-6 letters
	int p2 = (int)(Math.random() * (key.length() - len));
	int pstop = p + len;
	int pstop2 = p2 + len;
	//	System.out.println("p= " + p + " len= " + len + " pstop= " + pstop + " p2= " + p2 + " pstop2= " + pstop2);

	// Avoid collisions
	int count = 0;
	while (collision(i1.key.substring(p,pstop), i2.key.substring(p2,pstop2)) || 
	       collision(i1.key.substring(p,pstop), i2.key.substring(p,pstop)) ||
	       collision(i1.key.substring(p2,pstop2), i2.key.substring(p2,pstop2)) ) {
	    ++count;
	    if (count >= 26) 
		break;
	    p--; pstop--; 
	    if (p < 0) { pstop = i1.key.length()-1; p = pstop - len; }
	    //	    System.out.println(" p= " + p + " pstop= " + pstop);
	}
	//	System.out.println(" p= " + p + " p2= " + p2);
	if (count >= 26)
	    return;         // Return without making cross

	while (p < pstop && p < key.length() && p2 < pstop2 && p2 < key.length()) 
	{
	    char ch1 = i1.key.charAt(p);
	    char ch2 = i2.key.charAt(p2);
	    i1.swap(ch1, ch2);
	    i2.swap(ch1, ch2);
	    p++;
	    p2++;
	}
	//	System.out.println("i1 after: " + i1.getKey() + "\ni2 after: " + i2.getKey());
	i1.calcFitness();  
	i2.calcFitness();
    }

    private boolean collision(String s1, String s2) {
	for (int k = 0; k < s1.length(); k++) 
	    if (s2.indexOf(s1.charAt(k)) != -1)
		return true;
	return false;
    }

    /**
     * This version of mutate swaps two random characters
     *  in the key. The mutation is done with frequency equal
     *  to rate. The resulting mutant is discarded if it
     *  does not improve the fitness of the individual.
     * @param rate is the mutation rate
    public int mutate(double rate) {
	int a = 0, b = 0;
        if (Math.random() < rate) {
	    TypeIVGaIndividual tempIndy = new TypeIVGaIndividual(this);
            a = (int)(Math.random() * 26);
            b = (int)(Math.random() * 26);
            char ch = key.charAt(a);
            key.setCharAt(a, key.charAt(b));
            key.setCharAt(b, ch);
            this.calcFitness();
	    if (mutate_policy == GaParameters.ELITIST_MUTATION && this.compareTo(tempIndy) > 0)  {     // We mutate only if better
		this.key = tempIndy.key;             // So, restore the individual's state  if mutation is not an improvement
		this.fitness = tempIndy.fitness;
		this.decrypt = tempIndy.decrypt;
		return 0;
	    } else {
		return 1;
	    }
        } else {
	    return 0;  
	}
    }
    ***********/

    public int mutate(double rate) {
	int a = 0, b = 0;
        if (Math.random() < rate) {
	    TypeIVGaIndividual tempIndy = new TypeIVGaIndividual(this);
	    boolean isLegal = false;
	    do {
		//		double select = Math.random();
		//		if (select < 0.5) {                // Swap 2 random letters in key
		    a = (int)(Math.random() * 26);
		    b = (int)(Math.random() * 26);
		    char ch = key.charAt(a);
		    key.setCharAt(a, key.charAt(b));
		    key.setCharAt(b, ch);
		    //		    isLegal = isLegal("egajsaistkoexuqwzd");
		    isLegal = isLegal(key, "egajsaistkoexuqwzd", shiftKeyMaps);
		    if (!isLegal) {
			ch = key.charAt(a);
			key.setCharAt(a, key.charAt(b));
			key.setCharAt(b, ch);
		    }
		    //		} else
		    //		    key = shiftL(key);          // Rotate left
	    } while (!isLegal);
	    this.calcFitness();
	    if (mutate_policy == GaParameters.ELITIST_MUTATION && this.compareTo(tempIndy) > 0)  {     // We mutate only if better
		//		System.out.println(this.fitness + " > " + tempIndy.fitness);
		this.key = tempIndy.key;             // So, restore the individual's state  if mutation is not an improvement
		this.fitness = tempIndy.fitness;
		this.decrypt = tempIndy.decrypt;
		return 0;
	    } else {
		return 1;
	    }
        } else {
	    return 0;  
	}
    }

    /**
     *  Shifts a random segment within sb to the left.
     */
    private StringBuffer shiftL(StringBuffer sb) {
	StringBuffer sbNew = new StringBuffer();
	int p = 2 + (int)(Math.random() * 19);
	int l = Math.min(2 + (int)(Math.random() * 5), 25 - p);
	sbNew.append(sb.substring(0,p));
	sbNew.append(sb.substring(p+1,p+1+l));
	sbNew.append(sb.charAt(p));
	sbNew.append(sb.substring(p+1+l));
	return(sbNew);
    }


    /**
     * Cuts the string at location p.
     */
    private StringBuffer cut(StringBuffer sb, int p) {
	StringBuffer newSb = new StringBuffer(sb.substring(p));
	newSb.append(sb.substring(0,p));
	return newSb;
    }

    /**
     * Reverses the letters in the string.
     */
    private StringBuffer reverse(StringBuffer sb) {
	StringBuffer sbNew = new StringBuffer();
	for (int k = sb.length()-1; k >= 0; k--)
	    sbNew.append(sb.charAt(k));
	return sbNew;
    }

    /**
     * Rotates the string 1 letter to the left.
     */
    private StringBuffer rotateL(StringBuffer sb) {
	return cut(sb,1);
    }


    /**
     * Rotates the string 1 letter to the right.
     */
    private StringBuffer rotateR(StringBuffer sb) {
	return cut(sb,sb.length()-1);
    }



//The method below does something different each time but chooses the second
// segment near the end of alphabet much too often.
//This would need to be improved
     /**
     *  randMoveSegments(key) modifies key by exchanging two randomly selected
     *  segments of key.
     *  @param key is a permutation key stored in a StringBuffer variable.
     */
     private void randMoveSegments(StringBuffer key){
         int m1 = 1 + (int)(Math.random() * 24 );
         int n1 = m1 + (int)(Math.random() * (25 - m1));
         int m2 = n1 + 1 + (int)(Math.random() * (25 - n1));
         int n2 = m2 + (int)(Math.random() * (26 - m2));
         moveSegments(key,m1,n1,m2,n2);
     } //randMoveSegments()


    /**
     *  moveSegments(key,m1,n1,m2,n2) modifies key by exchanging the segment
     *  from first letter at m1 to last letter at n1 with the segment from m2
     *  to n2.  The characters between the two segments are shifted as needed.
     *  @param key is a permutation key stored in a StringBuffer variable.
     *  @param m1 is a location of the first letter of a first segment. 1 <= m1 <=24
     *  @param n1 is a location of the last letter of a first segment. m1 <= n1 <=24
     *  @param m2 is a location of the 1st letter of a 2nd segment. n1< m2 <=25
     *  @param n2 is a location of the 1st letter of a 2nd segment. m2 <= n2 <=25
     */
     private void moveSegments(StringBuffer key, int m1, int n1, int m2, int n2){
         for (int k = 0; k < 26; k++)             // Copy key to tempKey
             tempKey.setCharAt(k,key.charAt(k));
         int tempKeyPos = m2;
         int keyPos = m1;
         while (tempKeyPos <= n2){         //copy second segment to key
             key.setCharAt(keyPos,tempKey.charAt(tempKeyPos));
             tempKeyPos++;
             keyPos++;
         } // while
         tempKeyPos = n1 + 1;
	 while (tempKeyPos < m2){           // copy chars between segments to key
             key.setCharAt(keyPos,tempKey.charAt(tempKeyPos));
             tempKeyPos++;
             keyPos++;
         } // while
         tempKeyPos = m1;
          while (tempKeyPos <= n1){          // copy first segment to key
             key.setCharAt(keyPos,tempKey.charAt(tempKeyPos));
             tempKeyPos++;
             keyPos++;
         } // while
     } // moveSegments()

    public void calcFitness() {
	try {
	    //	    String correctkey="ublyncmzdfoegprhqwisajvtkx,ublyncmzdfoegprhqwisajvtkx,aunty/az";
	    typeIVKey.init(key + "," + key + "," + shiftKey.toString() + "/az");
	    //	    typeIVKey.init(key + "," + "abcdefghijklmnopqrstuvwxyz" + "," + shiftKey.toString() + "/az");
	    //	    typeIVKey.init(correctkey);
            cipher.init(typeIVKey);
	    decrypt = cipher.decrypt(this.text);
	    fitness = ngramArr.recipDistSkip(decrypt);
	    //	    System.out.println(key + "," + key + "," + shiftKey.toString() + "/az " + decrypt.substring(0,30) + " " + fitness);
	    //	    System.out.println(correctkey + " " + decrypt.substring(0,30) + " " + fitness + " NN= " + ngramArr.getNN() + " step= " + ngramArr.getStepSize());
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }


    public double calcIC(int nCols) {
	String substituteText = new String(substitute(this.text,key));         
	String decrypt = shiftText(substituteText, shiftKey.toString());
	FastIC fastIC = new FastIC(decrypt, shiftKey.length());
	double sum = 0;
	for (int k = 0; k < nCols; k++)
	    sum += fastIC.getColumnIC(k);
	return sum / nCols;
    }


    public double calcCHI(int nCols) {
	String substituteText = new String(substitute(this.text,key));         
	String decrypt = shiftText(substituteText, shiftKey.toString());
	FastIC fastIC = new FastIC(decrypt, shiftKey.length());
	double sum = 0;
	for (int k = 0; k < nCols; k++)
	    sum += fastIC.getBestChiTestPerEnglish(k);
	return sum / nCols;
    }


    private String substitute(String s, StringBuffer key) {
	//	System.out.println("length = " + s.length());
	StringBuffer sb = new StringBuffer();
	for (int k = 0; k < s.length(); k++) {
	    sb.append(key.charAt(s.charAt(k)-'a'));
	}
	return new String(sb.toString());
    }

    /**
     * shiftText() breaks text into keywd.length() columns,
     *  shifts each columns by the keywd[k], and returns the merged
     *  columns.
     */
    private String shiftText(String text, String keywd) {
	int period = keywd.length();
	String columns[] = new String[period];
	columns = getKColumns(text, period);
	for (int k = 0; k < period; k++) 
	    columns[k] = shift(columns[k], keywd.charAt(k)-'a');
	return mergeColumns(columns);
    }

    /**
     * shift() shifts each character in the string s by n, assuming a 26
     *  letter alphabet
     * @param s, a text
     * @param n -- the amount to shift each letter
     */
    private String shift (String s, int n) {
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < s.length(); k++) {
            char ch = s.charAt(k);
            sb.append((char)('a' + ((ch - 'a') + n) % 26));
	}
        return sb.toString();
    }    


    /**
     * mergeColumns() merges the columns into a single string of text.
     *  This method is used to reconstruct the original message
     * @param columns -- an array of the k simple substitution subtexts
     *  of the original message.
     */
    private String mergeColumns(String columns[]) {
	int d = Math.min(columns[0].length(), columns[columns.length-1].length());
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < d; k++) 
            for (int j = 0; j < columns.length; j++) 
                sb.append(columns[j].charAt(k));
	for (int j = 0; j < columns.length; j++)
	    if (columns[j].length() > d)
		sb.append(columns[j].charAt(d));
        return sb.toString();
    }

    /**
     * getKColumns() converts the text, s, into an array of k columns. If k
     *  corresponds to the period of the Alberti cipher, then each column
     *  is a simple substitution cipher.
     * @param s -- the ciphertext
     * @param k -- the period
     */
    private String[] getKColumns(String s, int k) {
        String columns[] = new String[k];
        if (k <= 0) 
            throw new IllegalArgumentException("Skip size must be positive");
	for (int j = 0; j < k; j++) {
            StringBuffer sb = new StringBuffer();
            for (int i = j; i < s.length(); i+=k) 
                sb.append(s.charAt(i));
            columns[j] = sb.toString();
	    //            System.out.println("Column " + j + ":" + columns[j]);
	}
        return columns;
    }

    /**
     *  Overrides the default version
     */
    public int compareTo(Object o) {
        TypeIVGaIndividual indy = (TypeIVGaIndividual)o;
	
	//System.out.println(this.fitness + " vs.  " + indy.fitness);
        
	if (this.fitness < indy.fitness)
            return -1;
        else if (this.fitness > indy.fitness)
            return +1;
        else
            return 0;
    }

    public String getKey() {
	return key + "," + shiftKey;
    }

    public String getShiftKey() {
	return shiftKey;
    }

    public String getPermKey() {
	return key.toString();
    }

}

