/*
 * File: WordBasedGaAnalyzer.java
 * @author R. Morelli <ralph.morelli@trincoll.edu> 
 * @author R. Walde <rwalde@nyc.rr.com> 
 * 
 * Description: This class assumes that the text is
 *  encrypted with simple substitution and uses a
 *  word-based genetic algorithm to analyze it.
 */

package analyzers;

import hcrypto.analyzer.*;
import hcrypto.cipher.*;
import hcrypto.engines.*;
import hcrypto.provider.*;

public class WordBasedGaAnalyzer extends CryptoAnalyzer {
    
    protected GaPopulation population;     
    protected PatternDictionary seed_dict;
    protected Dictionary eval_dict;

    /**
     * WordBasedGaAnalyzer() -- Default constructor
     */
    public WordBasedGaAnalyzer() {
	super();
    }

    /**
     * WordBasedGaAnalyzer() -- this constructor is given an object containing parameter settings
     * @param params -- an object containing param1=val1 param2=val2 ...
     */
    public WordBasedGaAnalyzer(GaParameters params) {
	super(params);
    }

    /**
     * setup() creates the population and its dictionaries
     *   CryptoAnalyzer class by creating a WordBasedGAPopulation object. 
     */
    public void setup(String text) {
	super.setup(text);
	if (params == null) {
	    params = new GaParameters();       // Default GaParameters
	}
	population = new WordBasedGaPopulation(this.text, TextUtilities.cleanString(this.solution), params);
	seed_dict = ((WordBasedGaPopulation) population).getSeedDict();
	eval_dict = ((WordBasedGaPopulation) population).getEvalDict();
    }


    /**
     * run() conducts the GA run and reports the results.
     */
    public void run() {
        String decrypt;
	if (display != null) {                          // For use with CryptoToolJ
	    population.setDisplay(display);
	}
	population.run();
	int n = 1;
	resultSB.append("HERE'S THE TOP " + n + "  RESULTS:\n");
	for (int k = 0; k < n; k++) {

	    String key = population.getFittest(k).getKey();
	    resultSB.append("\nKey (" + k + ") = " + population.getFittest(k).displayCrossData() + "\n");

	    try {
		Provider.addProvider(new DefaultProvider("Default"));
		Cipher cipher = Cipher.getInstance("Substitution");
		SubstitutionKey sKey = (SubstitutionKey) HistoricalKey.getInstance("Substitution", cipher.getProvider());
		sKey.init(key + "/az");
		cipher.init(sKey);
		if (text.length() <= Analyzer.DECIPHER_LIMIT)
		    decrypt = cipher.decrypt(text);
		else
		    decrypt = cipher.decrypt(text.substring(0, Analyzer.DECIPHER_LIMIT));
		String decrypt2 = TextUtilities.markWords(eval_dict, decrypt);
		solution = TextUtilities.markWords(eval_dict, solution);
		resultSB.append("-------------\nDECRYPTED MESSAGE(" + k + "): \n" + decrypt2);
		resultSB.append("\nSOLUTION(" + k + "):\n" + solution + "\n");
		resultSB.append("PERCENT WORDS: " + num.format(TextUtilities.percentWords(solution,decrypt2)) + "\n");
		resultSB.append("WRONG CHARS: " + TextUtilities.countInCorrectChars(solution,decrypt2) + "\n-------------\n");
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	    if (display != null) {                          // For use with CryptoToolJ
		display.append(resultSB.toString());
	    }
	}
    }
}

