package hcrypto.analyzer;

import hcrypto.cipher.*;
import hcrypto.engines.*;
import hcrypto.provider.*;

import java.util.*;

public class WordBasedGaIndividual extends GaIndividual implements Comparable {
    public StringBuffer unusedLetters = new StringBuffer();
    public StringBuffer usedLetters = new StringBuffer();
    public String usedLettersNoDups = "";
    public String used_decrypt = "";
    public String unused_decrypt = "";
    
    public int word_count = 0;

    private Dictionary eval_dict;
    private double A, B, C;

    /**
     * This constructor takes an initial distribution for the key as
     *  a parameter. 
     * @param text -- A string giving the text to be decrypted.
     * @param initKey -- A string giving the initial values for the key.
     */
    public WordBasedGaIndividual(String text, String initKey, Dictionary d, GaParameters p) {
	super(text,initKey,p);
	eval_dict = d;
	params = p;
	A = params.eval_A;
	B = params.eval_B;
	C = params.eval_C;
	mutate_policy = params.mutate_policy;
    }

    /**
     * Copy constructor
     */
    public WordBasedGaIndividual (GaIndividual i) {
	super(i);
        unusedLetters = ((WordBasedGaIndividual)i).unusedLetters;
        usedLetters = ((WordBasedGaIndividual)i).usedLetters;
	usedLettersNoDups = ((WordBasedGaIndividual)i).usedLettersNoDups;
	used_decrypt = ((WordBasedGaIndividual)i).used_decrypt;
	eval_dict = ((WordBasedGaIndividual)i).eval_dict;
	A = ((WordBasedGaIndividual)i).A;
	B = ((WordBasedGaIndividual)i).B;
	C = ((WordBasedGaIndividual)i).C;
    }

    /** 
     * This version of cross swaps characters from each individual's
     *  list of characters used in the words found by each individual's key.
     *  If the OCCURS check is included -- that is, if a check is made to
     *  insure that a swap will not negate a key's decrypt of a word --
     *  then this algorithm will guarantee that the children are no
     *  worse than their parents at finding words. In experimental runs,
     *  approximately half the crosses result in improvements and half in
     *  no change. Without the occurs check a very small percentage of all
     *  crosses lead to improvement and a slightly smaller percentage produce
     *  children that are actually lower scoring than their parents.
     *  MODIFICATION: 11/5/02. Added some swapping of unused characters.
     *  @param i1 an Individual parent
     *  @param i2 an Individual parent
     */
    public void cross(GaIndividual i) {
	WordBasedGaIndividual i1 = this;
	WordBasedGaIndividual i2 = (WordBasedGaIndividual)i;
	//        i1.calcFitness();
	//        i2.calcFitness();
	/*************
	double f1 = i1.getFitness();
        double f2 = i2.getFitness();
	System.out.println("i1: " + i1.getKey() + " " + i1.usedLetters.toString() + 
                           "\ni2: " + i2.getKey() + " " + i2.usedLetters.toString());
	System.out.println("Used1= " + i1.usedLettersNoDups + " used2= " + i2.usedLettersNoDups);
	System.out.println("Decr1= " + i1.used_decrypt + " decr2= " + i2.used_decrypt);
	***************/

	for (int k = 0; k < i1.usedLettersNoDups.length(); k++) {
	    char ch = i1.usedLettersNoDups.charAt(k);
	    char a = i1.key.charAt(ch-'a');
            char b = i2.key.charAt(ch-'a'); 
	    //	    if (i2.used_decrypt.indexOf(a) == -1 &&  // OCCURS Check
	    //		i2.used_decrypt.indexOf(b) == -1) {  // If character doesn't mess up decrypt of i2
		//		System.out.println("Swap i2 a= " + a + " b= " + b);
		i2.swap(a,b);
		//	    }
	}

	for (int k = 0; k < i2.usedLettersNoDups.length(); k++) {
	    char ch = i2.usedLettersNoDups.charAt(k);
	    char a = i2.key.charAt(ch-'a');
            char b = i1.key.charAt(ch-'a'); 
	    //	    if (i1.used_decrypt.indexOf(a) == -1 &&   // OCCURS check
	    //		i1.used_decrypt.indexOf(b) == -1 ) {  // if character doesn't mess up decrypt of i1
		//		System.out.println("Swap i1 a= " + a + " b= " + b);
		i1.swap(a,b);
		//	    }
	}


        i1.calcFitness();
        i2.calcFitness();
	/**************
        double f11 = i1.getFitness();
        double f22 = i2.getFitness();
	System.out.println("f1= " + f1 + " f11= " + f11 + " f2= " + f2 + " f22= " + f22);
	*************/
    }

    /**
     * This version of mutate swaps two random characters
     *  in the key. The mutation is done with frequency equal
     *  to rate. The resulting mutant is discarded if it
     *  does not improve the fitness of the individual.
     * @param rate is the mutation rate
     */
    public int mutate(double rate) {
        if (Math.random() < rate) {
	    GaIndividual temp = new WordBasedGaIndividual(this);
            int a = (int)(Math.random() * 26);
            int b = (int)(Math.random() * 26);
            char ch = key.charAt(a);
            key.setCharAt(a, key.charAt(b));
            key.setCharAt(b, ch);
            this.calcFitness();
	    if (mutate_policy == GaParameters.ELITIST_MUTATION && this.getFitness() < temp.getFitness())  {     // Mutate only if better
                this.key = temp.key;
                this.fitness = temp.fitness;
		this.decrypt = temp.decrypt;
		return 0;
	    } else {
		return 1;
	    }
        } else {
	    return 0;
	}
    }

    /**
     * This version of mutate swaps two unused characters
     *  in the key. The mutation is done with frequency equal
     *  to rate. The resulting mutant is discarded if it
     *  does not improve the fitness of the individual.
     * @param rate is the mutation rate
     */
    public int mutateUnused(double rate) {
        GaIndividual temp = new WordBasedGaIndividual(this);
	int len = unused_decrypt.length();
	int a = (int)(Math.random() * len);
	int b = (int)(Math.random() * len);
	char ch = unused_decrypt.charAt(a);
	char ch2 = unused_decrypt.charAt(b);
	//	System.out.print("*");
	//	System.out.println("mutateUnused(): " + unused_decrypt + " " + ch + " " + ch2); 
	//	System.out.println(key.toString());
	swap(ch, ch2);
	//	System.out.println(key.toString());
	this.calcFitness();
	if (this.getFitness() < temp.getFitness())  {     // Mutate only if better
	    //	    this.key = temp.key;
	    //	    this.fitness = temp.fitness;
	    return 1;
	}
	return 0;
    }

    public void calcFitness() {
        try {
            sKey.init(key.toString() + "/az");
            cipher.init(sKey);
            if (ciphertext.length() <= Analyzer.DECIPHER_LIMIT)
                decrypt = cipher.decrypt(ciphertext);
            else
                decrypt = cipher.decrypt(ciphertext.substring(0, Analyzer.DECIPHER_LIMIT));
	    //	    System.out.println("decrypt= " + decrypt);
        } catch (Exception e) {
	    e.printStackTrace();
        }
        usedLetters = new StringBuffer();
	//	fitness = TextUtilities.evaluate(decrypt, usedLetters);
	fitness = evaluate(decrypt, usedLetters);
	//	word_count = TextUtilities.countWords(decrypt);

	usedLettersNoDups = "";
	used_decrypt = "";
	unused_decrypt = "";
	for (int k = 0; k < usedLetters.length(); k++) {  // Remove duplicate letters
	    char ch = usedLetters.charAt(k);
	    if (usedLettersNoDups.indexOf(ch) == -1) {
		usedLettersNoDups = usedLettersNoDups + ch;
		used_decrypt = used_decrypt + key.charAt(ch-'a'); // Make decrypt of used letters
	    }
	}
	for (char ch = 'a'; ch <= 'z'; ch++)         // FIll in string used in mutation
	    if (used_decrypt.indexOf(ch) == -1)
		unused_decrypt = unused_decrypt + ch;

	//	System.out.println("CALC " + key.toString() + " score=" + fitness + " USED: " + usedLetters.toString());
       
    }

    public double evaluate(String text, StringBuffer usedLetters) {
	//        System.out.println("EVALUATE: TEXT= " + text + "\nUSED " + usedLetters);
	//        String alphabet = "abcdefghijklmnopqrstuvwxyz";
	//        StringBuffer sb = new StringBuffer(alphabet);

	//	System.out.println("Evaluate: A= " + A + " B= " + B + " C= " + C);

        StringTokenizer st = new StringTokenizer(text);
        int count = 0;             // Number of words found
	double freqs = 0;          // Sum of frequecies
	double chars = 0;          // Total chars
	double charsInWords = 0;   // Chars in words found
        while (st.hasMoreTokens()) {
	    String s = st.nextToken();
	    chars += s.length();
	    if (eval_dict.contains(s)) {
	    //	    if (big_eval_dict.contains(s)) {
		//		System.out.print(s + " ");
		count++;
		//		freqs += big_eval_dict.getFreq(s);
		freqs += eval_dict.getFreq(s);
		charsInWords += s.length();
		usedLetters.append(s);
            }
        }
        return A * count + B * charsInWords/chars + C * freqs;
    }

    public String displayCrossData() {
	return getKey() + " (" + getFitness() + ") " + usedLetters.toString()    ;
    }

    public String toString() {
	return getKey() + " Used " + usedLetters.toString();
	//	return "" + word_count + " " + getKey() + " Used " + usedLetters.toString();
    }

}

