package hcrypto.cipher;


public class UnicodeRanges {


    public static char getRangeLow(Character.UnicodeBlock b) {
        if (b == Character.UnicodeBlock.ARABIC)
                return 0x600;
        else if (b == Character.UnicodeBlock.DINGBATS)
                return 0x2700;
        else if (b == Character.UnicodeBlock.GREEK)
                return 0x370;
        else if (b == Character.UnicodeBlock.GREEK_EXTENDED)
                return 0x1F00;
        else if (b == Character.UnicodeBlock.HEBREW)
                return 0x590;
        else if (b == Character.UnicodeBlock.HIRAGANA)
                return 0x3040;
        else if (b == Character.UnicodeBlock.KATAKANA)
                return 0x30A0;
        else if (b == Character.UnicodeBlock.MATHEMATICAL_OPERATORS)
                return 0x2200;
        else
                return 0x0;
    }           

    public static char getRangeHigh(Character.UnicodeBlock b) {
        if (b == Character.UnicodeBlock.ARABIC)
                return 0x6FF;
        else if (b == Character.UnicodeBlock.DINGBATS)
                return 0x27BF;
        else if (b == Character.UnicodeBlock.GREEK)
                return 0x3CF;
        else if (b == Character.UnicodeBlock.GREEK_EXTENDED)
                return 0x1FFF;
        else if (b == Character.UnicodeBlock.HEBREW)
                return 0x5FF;
        else if (b == Character.UnicodeBlock.HIRAGANA)
                return 0x309F;
        else if (b == Character.UnicodeBlock.KATAKANA)
                return 0x30FF;
        else if (b == Character.UnicodeBlock.MATHEMATICAL_OPERATORS)
                return 0x22FF;
        else
                return 0x0;
    }           

    /**
     * Returns the first character in the range described by
     *  its parameter. 
     * @param s a String that names one of the valid UnicodeBlock
     *  ranges. For example, "UnicodeBlock.GREEK" or "UnicodeBlock.KATAKANA"
     */
    public static char getRangeLow(String s){
        char ch = 0;
        String fieldName = s.substring(s.indexOf(".")+1);
        try {
	    Class c = Class.forName("java.lang.Character$UnicodeBlock");
	    //	    java.lang.reflect.Field fs[] = c.getFields();
	    //            for (int k = 0; k < fs.length; k++)
	    //                System.out.println("Fields: " + fs[k].getName());
            java.lang.reflect.Field f = c.getField(fieldName);
            ch = getRangeLow((Character.UnicodeBlock)f.get(c));
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchFieldException e) {
            System.err.println("Field = " + fieldName);
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ch;
    }

    /**
     * Returns the last character in the range described by
     *  its parameter. 
     * @param s a String that names one of the valid UnicodeBlock
     *  ranges. For example, "GREEK" or "KATAKANA"
     */
    public static char getRangeHigh(String s) {
        char ch = 0;
        String fieldName = s.substring(s.indexOf(".")+1);
        try {
            Class c = Class.forName("java.lang.Character$UnicodeBlock");
            java.lang.reflect.Field f = c.getField(fieldName);
            ch =  getRangeHigh((Character.UnicodeBlock)f.get(c));
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
            System.err.println("Field = " + fieldName);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return ch;
    }

    public static void main(String args[]) {
        System.out.println("Arabic " + (int)getRangeLow(Character.UnicodeBlock.ARABIC));
        System.out.println("Hebrew " + (int)getRangeLow(Character.UnicodeBlock.HEBREW));
        System.out.println("Hiragana " + (int)getRangeLow(Character.UnicodeBlock.HIRAGANA));
        System.out.println("Katakana " + (int)getRangeLow(Character.UnicodeBlock.KATAKANA));
    }

}
