package hcrypto.engines;
//package plugins;

import hcrypto.cipher.*;
import hcrypto.provider.*;
import java.util.StringTokenizer;

//ALBERTI CIPHER FINISHED JUNE 18, 2003 -WILL SERVOS
/**
 * AlbertiEngine.java implements a modified Alberti Cipher for
 *  the full range of alphabets -- az, AZ, azAZ, azAZ09, printable characters, and all ASCII.
 *  The encoding method is based upon the following function:
 *      CipherChar = (KeywordAlph)PlainChar + KeyChar
 *  The decoding method is based upon the following function:
 *      PlainChar = (KeywordAlph)CipherChar - KeyChar
 *
 *  A traditional Alberti cipher assumes that the alphabet is the latin alphabet
 *  minus some letters deemed "redundant" and plus 1-4 and that the key 
 *  characters are in the normal latin alphabet plus et, which probably meant &. 
 *  However, for this system the key character may not be in the same range as the
 *  cipher of plain character. In that case, the key character must
 *  be scaled to fall into the range of the plain or cipher character.
 *  For example, if the plain character is a digit, '5', and the key
 *  character is the letter 't', then 't' must be scaled to a value
 *  between 0 and 9. Since 't' is character 19 in a..z, we scale it
 *  to 9 ( = 19 % 10). This allows us to shift '5' by 9 (% 10), giving '4'.
 *  On decoding, the key characters 't' will occur above '4'. Again
 *  we scale to 't' to 9 and perform subtraction (% 10) to get '5'.
 *  
 *  A similar kind of scaling occurs for other alphabet ranges.
 *
 *<P>See also:
 *  <BLOCKQUOTE> 
 *      <BR><a href="AlbertiKey.html">AlbertiKey</a>
 *      <BR><a href="../cipher/Alphabet.html">Alphabet</a>
 *  </BLOCKQUOTE> 
 */

public class AlbertiEngine extends BlockCipher   //DOCUMENTED BY Will
{
	private String shiftkey;
	private String permutekey;
	private AlbertiKey key;
	private char[] cipherKey;
	private char[] plainKey;
	private int ShiftPtr;
	private int keyPtr;        // Cycles through chars in keyword
    
	/**
	 * Creates a AlbertiEngine and sets the <i>alphabetRangeOptions</i> instance variable
	 * to "111111", which translates to all six alphabet options.
	 */ 
    	
    
	public AlbertiEngine() 
	{
        	alphabetRangeOptions = "111111/111111";  // Alberti allows all 6 possible alphabet ranges
	}

	/**
	 * Initializes the AlbertiEngine with the specified hKey.
	 * @param hKey a AlbertiKey.
	 */
    
	protected void engineInit(HistoricalKey hKey) throws Exception 
	{
		if ( !(hKey instanceof AlbertiKey))
        		throw new Exception("InvalidKey: Alberti requires AlbertiKey");
		key = (AlbertiKey) hKey;
	        alphabet = key.getAlphabet();
        	cipherAlphabet = key.getCTAlphabet();
	        shiftkey = key.getShiftKey();
		permutekey = key.getPermutationKey();
	        this.blocksize = key.getBlocksize();
		cipherKey = key.getCipherKey();
		plainKey = key.getPlainKey();
		ShiftPtr = 0;				// Initializes ShiftPtr
	        keyPtr = 0;                         // Initialize keyPtr

	/******
		System.out.print("     \tABCDEFGHIJKLMNOPQRSTUVWXYZ\nPlain:\t");
		for(int i = 0; i < plainKey.length; i++) { //Displays the alphabets in use
		    System.out.print(plainKey[i]);
		}
		System.out.print("\nCipher:\t");
		for(int i = 0; i < cipherKey.length; i++) { 
		    System.out.print(cipherKey[i]);
		}
		System.out.println("");
	**************/

		//		printEncryptSquare(cipherKey);
		//		printDecryptSquare(plainKey);
     
	}
	

	/**
	 * Returns an encoded String for the specified String.  
	 *  Characters which are not part of the chosen alphabet set are ignored.
	 * @param s the String to be encrypted
	 * @return String representing the encrypted input
	 */

	public String engineEncode( String s ) throws Exception {
	    if (blocksize != 1)
		throw new Exception("Invalid blocksize for Alberti cipher " + blocksize);        
	    char ch = s.charAt(0);
	    if (alphabet.isInAlphabet(ch)) {
		char keyCh = shiftkey.charAt(keyPtr);
                char ciphCh = cipherKey[alphabet.charToInt(ch)];
		char newCh = encodeShift(ciphCh,alphabet.charToInt(keyCh));
		//		char newCh = encodeShift(ch,alphabet.charToInt(keyCh));
		keyPtr = (keyPtr + 1) % shiftkey.length();
		//            System.out.println(ch + " " + low + " " + high + " " + keyCh + " " + range + " " + theShift + " " + newCh);
		return "" + newCh;
	    }
	    else
		return s;
    	}  //engineEncode

	/**
	 * Finds the index of a given character
	 * @param char c in the char plainKey[]
	 * @return int the index of char c
	 */
	public int indexOfPlain(char c) throws Exception {
	    int index = 0;	
	    for(int i = 0; i < plainKey.length; i++) {
		if(c == plainKey[i])
		    return index;
		index++;
	    }
	    throw new Exception("The character was not found in the index.");
	}

	/**
	 * Finds the index of a given character 
	 * @param char c in the char plainKey[]
	 * @return int the index of char c
	 */
	public int indexOfCiph(char c) throws Exception	{
	    int index = 0;	
	    for(int i = 0; i < cipherKey.length; i++) {
		//System.out.print(" " + index);
		if(c == cipherKey[i])
		    return index;
		index++;
	    }
	    throw new Exception("The character was not found in the index.");
	}

	/**
   	 * Returns a decoded String for the specified String.  
   	 * Characters which are not part of the chosen alphabet set are ignored.
   	 * @param s the String to be decrypted
	 * @return String representing the decrypted input
    	 */
    
    public String engineDecode( String s ) throws Exception {
	if (blocksize != 1)
	    throw new Exception("Invalid blocksize for Alberti cipher " + blocksize);
	char ch = s.charAt(0);
	if (cipherAlphabet.isInAlphabet(ch))  {
	    char keyCh = shiftkey.charAt(keyPtr);
	    char plainCh = decodeShift(ch,alphabet.getSize() - alphabet.charToInt(keyCh));
            char newCh = plainKey[cipherAlphabet.charToInt(plainCh)];
	    //	    char newCh = decodeShift(ch,alphabet.getSize() - alphabet.charToInt(keyCh));
	    //		        char newCh = decodeShift(ch,alphabet.charToInt(keyCh));
	    keyPtr = (keyPtr + 1) % shiftkey.length();
	    //   System.out.println(ch + " " + low + " " + high + " " + keyCh + " " + range + " " + theShift + " " + newCh);
	    return "" + newCh;
	}
	else
	    return s;
    } //engineDecode

    protected void printEncryptSquare(char alpha[]) {
	//	String primary = "abcdefghijklmnopqrstuvwxyz";
	char ch = 'A';
	System.out.println("\t   0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5");
	System.out.println("\t   A B C D E F G H I J K L M N O P Q R S T U V W X Y Z");
	for (int j = 0; j < 26; j++) {
	    System.out.print(j + "\t" + (char)(ch + j) + ": ");
	    for (int k = 0; k < alpha.length;  k++) {
		System.out.print((char)('a' + (alpha[k] - 'a' + j) % alpha.length) + " ");
	    }
	    System.out.println();
	}
    }

    protected void printDecryptSquare(char alpha[]) {
	//	String primary = "abcdefghijklmnopqrstuvwxyz";
	char ch = 'A';
	System.out.println("\t   0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5");
	System.out.println("\t   A B C D E F G H I J K L M N O P Q R S T U V W X Y Z");
	for (int j = 0; j < 26; j++) {
	    System.out.print(j + "\t" + (char)(ch + j) + ": ");
	    for (int k = 0; k < alpha.length;  k++) {
		System.out.print((char)('a' + (alpha[(k + 26 - j) % alpha.length] -'a') ) + " ");
	    }
	    System.out.println();
	}
    }

}  //AlbertiEngine class
