package hcrypto.engines;

import hcrypto.cipher.*;

/**
 * This class represents a key for a Beaufort cipher. The key
 * is entirely represented by a keyword String composed of characters from the chosen alphabet. 
 * <p>For this implementation of Beaufort cipher any of the alphabet ranges
 * can be used.
 * 
 * A Beaufort cipher is a variation of Vigenere. A Beaufort cipher is
 * self-reciprocal, meaning that the same tableaux can be used for
 * encryption and decryption.  For a 26 letter alphabet, with a key of
 * k, Beaufort encryption and decryption are given by the formula: 
 *         c = (k - p) % 26
 * where 'c' is the cipher text and 'p' is the plaintext.
 * 
 * <P>See also:
 *  <BLOCKQUOTE> 
 *      <BR><a href="BeaufortEngine.html">BeaufortEngine</a>
 *      <BR><a href="../cipher/Alphabet.html">Alphabet</a>
 *  </BLOCKQUOTE> 
 */

public class BeaufortKey extends VigenereKey {
   /**
    * Returns the name of the algorithm "Beaufort".
    */
      
    public String getAlgorithm() { 
        return "Beaufort"; 
    }   
}
