package hcrypto.engines;

import hcrypto.cipher.*;

/**
 * This class represents a key for a Enigma machine.
 *<P>See also:
 *  <BLOCKQUOTE> 
 *      <BR><a href="CaesarEngine.html">CaesarEngine</a>
 *      <BR><a href="../cipher/Alphabet.html">Alphabet</a>
 *  </BLOCKQUOTE> 
 */
  

public class EnigmaKey extends HistoricalKey {
    private String rotors = "";
    private String ringSettings = "";
    private String keySettings = "";
    private String plugboardSettings = "";
    
   /**
    * A description for a Enigma Key.
    */ 
    
    public final static String DEFAULT_KEY_DESCRIPTOR_PROMPT_STRING = "123,AAA,ABC,AC-DE-FG-WY";
    
    
   /**
    * A default key value.
    */
     
    public final static String DEFAULT_KEYWORD_STRING = "";
    
   
    /**
     * Default constructor required.
     */
    public EnigmaKey() { }

   /**
    * Initializes the EnigmaKey with the specified keyspec.
    * @param keySpec takes the form "123,AAA,ABC,AC-DE-FG-WY/azAZ";
    */ 
    public void init(String keyspec) throws Exception { 
	//        initKey(keyspec, false);             // Inherited from superclass
	try {
	    alphabet = AlphabetFactory.getInstance("AZ");
	    cipherAlphabet = AlphabetFactory.getInstance("AZ");
	    this.blocksize = 1;
	    this.keyDescriptorPrompt = "123,AAA,ABC,AC-DE-FG-WY";
	    rotors = keyspec.substring(0,3);
	    ringSettings = keyspec.substring(4,7);
	    keySettings = keyspec.substring(8,11);
	    plugboardSettings = keyspec.substring(12,keyspec.indexOf("/"));
	    //	System.out.println("Enigma Key: " + rotors + "," + ringSettings + "," + keySettings + "," + plugboardSettings);        
	} catch (Exception e) {
	    System.err.println("Valid Keyspec: " + this.keyDescriptorPrompt);
	    e.printStackTrace();
	}
    }

   /**
    * Initializes the CaesarKey given a keyword and one or more alphabets.
    * @param keyword -- a string version of the keyword
    * @param alpha1, alpha2 -- Alphabets for plain/ciphertext respectively. May
    *  be identical.
    */ 
    public void init(String keyword, Alphabet alpha1, Alphabet alpha2) throws Exception { 
	if (alpha1 == null || alpha2 == null)
	    throw new Exception("CaesarKey.init(): Null alphabet reference passed");
        super.initKey(keyword, alpha1, alpha2);
        this.keyword = keyword;
        this.keyDescriptorPrompt = "123,AAA,ABC,AC-DE-FG-WY";
	rotors = keyspec.substring(0,3);
        ringSettings = keyspec.substring(4,7);
        keySettings = keyspec.substring(8,11);
        plugboardSettings = keyspec.substring(12,keyspec.indexOf("/"));
	System.out.println("Enigma Key: " + rotors + "," + ringSettings + "," + keySettings + "," + plugboardSettings);        
    }

    public String getRotors() { return rotors; }
    public String getRingSettings() { return ringSettings; } 
    public String getKeySettings() { return keySettings; } 
    public String getPlugboardSettings() { return plugboardSettings; } 

   /**
    * Returns the algorithm name
    */
     
    public String getAlgorithm() { 
        return "Enigma Machine"; 
    }   
}
