/***********************
 *Author: R.Morelli
 *File: RailfenceEngine.java
 *Date: 4/5/03
 *
 *This file implements the Historical Railfence cipher.
 ************************/

package hcrypto.engines;

import java.awt.*;
import java.lang.String;
import hcrypto.cipher.*;

public class RailfenceEngine extends hcrypto.cipher.BlockCipher {
    private RailfenceKey key;
    private String keyword;
		
	
   /**
    * Creates a RailFenceEngine and sets the <i>alphabetRangeOptions</i> instance variable
    * to "111111", which translates to all six alphabet options for both the plaintext
    * and ciphertext alphabets.
    */ 
    
    public RailfenceEngine() {
        alphabetRangeOptions = "111111/111111";  // Railfence allows all 6 possible alphabet ranges
    }

   /**
    * Initializes the RailfenceEngine with the specified hKey.
    * @param hKey a RailfenceKey.
    */
    protected void engineInit(HistoricalKey hKey) throws Exception{
        if ( !(hKey instanceof RailfenceKey))
            throw new Exception("InvalidKey: Railfence requires RailfenceKey");
	key = (RailfenceKey) hKey;
        alphabet = key.getAlphabet();
        cipherAlphabet = key.getCTAlphabet();
	this.blocksize = key.getBlocksize();
        this.keyword = key.getKeyword();
    }
	
    private String removeWhitespace (String s) {
	StringBuffer sb = new StringBuffer("");
	for (int k = 0; k < s.length(); k++) {
	    char ch = s.charAt(k);
	    if (ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r')
		sb.append(s.charAt(k));
	}
	return sb.toString();
    }

    /**
     * engineEncrypt() overrides BlockCipher.engineEncrypt() because
     *  we want to process the entire cryptogram as a single string
     *  rather than break it up into blocks
     */
    protected String engineEncrypt(String str) throws Exception{
	return engineEncode(removeWhitespace(str));
    }

    /**
     * engineDecrypt() overrides BlockCipher.engineEncrypt() because
     *  we want to process the entire cryptogram as a single string
     *  rather than break it up into blocks
     */
    protected String engineDecrypt(String str) throws Exception{
	return engineDecode(removeWhitespace(str));
    }

    public String engineEncode(String str)throws Exception{
	StringBuffer sb = new StringBuffer("");
	int length = str.length();
	int nrows = Integer.parseInt(keyword);  // e.g, keyword = "25"
	int rmdr = length % nrows;
	char padchar = 'a';            // Padding: if rmdr=0, nrows of padding is used
	int nchars = nrows - rmdr;     // a=1, b=2, c=3,... number of padding characters
	if (rmdr == 0) {
	    padchar = (char)('a' + nrows -1); 
	    nchars = nrows;
	}
	else 
	    padchar = (char)('a'  + nchars - 1);
	System.out.println("len = " + length + " nrows=" + nrows + " rmdr= " + rmdr + " " + padchar);

	for (int k = 0; k < nrows; k++)
	    str = str + "" + padchar;

	length = str.length();
	int ncols = length / nrows;
	for (int row = 0; row < nrows; row++) 
	    for (int col = 0; col < ncols; col++)
		sb.append(str.charAt(row + nrows * col));
	return sb.toString();
	
	/**********************

	int nBlocks = str.length()/blocksize;
	int shortcols = blocksize;
	if (str.length() % blocksize != 0) {
	    ++nBlocks;
	    shortcols = str.length() % blocksize;
	}
	
	char crypto[] = new char[str.length()];

	int indx = 0;
	int ch = 0;
	int colNum = 0;
	for (int col = 0; col < blocksize; col++)
	    for (int row = 0; row < nBlocks; row++) {
		colNum = keyword.charAt(col) - '0';
		if (!((row == (nBlocks-1)) && (colNum >= shortcols))) {
		    indx = blocksize * row + colNum;
		    //		    System.out.println("row= " + row + " col= " + colNum + " indx= " + indx);
		    crypto[ch] = str.charAt(indx);
		    ch++;
		}
	    }
	//	System.out.println();
	return new String(crypto);
	**********************/
    }
		
    /**
     *  engineDecode() 
     *  @param cText is the entire cryptotext, which is assumed in this
     *   implementation to be some number of evenly-sized blocks of length blocksize
     * 
     */
    public String engineDecode(String cText) {
	String str= cText;
	StringBuffer sb = new StringBuffer("");
	int length = str.length();
	int nrows = Integer.parseInt(keyword);  // e.g, keyword = "25"
	int rmdr = length % nrows;
	length = str.length();

	char padchar = str.charAt(str.length()-1);   // How much padding
	int nchars = padchar-'a'+1;

	System.out.println("len = " + length + " nrows=" + nrows + " rmdr= " + rmdr + " " + padchar + " nchars= " + nchars);
	int ncols = length / nrows;
	for (int col = 0; col < ncols; col++)
	    for (int row = 0; row < nrows; row++) 
		sb.append(str.charAt(col + row * ncols));
	//	str = str.substring(0,str.length()-nchars);
	return sb.toString().substring(0, str.length()-nchars);  // Remove the padding

	/*************
	int nBlocks = cText.length()/blocksize;
	int shortcols = blocksize;
	if (cText.length() % blocksize != 0) {
	    ++nBlocks;
	    shortcols = cText.length() % blocksize;
	}
	

	//	System.out.println("Blocksize= " + blocksize + " nBlks= " + nBlocks + " Key: " + printkey(key));
	
	char plain[] = new char[cText.length()];
	
	int ch = 0;
	int colNum = 0;
	for (int col = 0; col < blocksize; col++)
	    for (int row = 0; row < nBlocks; row++) {
		colNum = keyword.charAt(col) - '0';
		if (!((row == (nBlocks-1)) && (colNum >= shortcols))) {
		    int indx = blocksize * row + colNum;
		    //		    System.out.println("blksz= " + blocksize + " row= " + row + " col= " + col + " indx= " + indx);
		    plain[indx] = cText.charAt(ch);
		    ch++;
		}
	    }
	//	System.out.println();
	return new String(plain);
	************/
    }

} //end Railfence Engine
