/**************************
 *Auhtor: R. Morelli
 *File RailfenceKey.java
 *Date: 4/5/03
 *
 *This file implements the Railfence Key
 *The keyspec, described in TestCipher.java
 *is passed to this file where the blocksize,
 *key and alphabet range is extracted.
 *The key determined the encryption of the cipher
 *The blockszie determines ahow many characters are 
 *encrypted at one time.
 ***************************/

package hcrypto.engines;

import hcrypto.cipher.*;

public class RailfenceKey extends HistoricalKey {  

   /**
    * A description for a RailFence Key.
    */ 
    
    public final static String DEFAULT_KEY_DESCRIPTOR_PROMPT_STRING = "a permutation of N columns";
    
    
   /**
    * A default key value.
    */
     
    public final static String DEFAULT_KEYWORD_STRING = "5"; // Number of rows
    
    /**
    * Creates a RailFenceKey with the specified keyspec.
    * @param keySpec takes the form "keyword/alphabet", 
    * i.e. "40321/azAZ09" for example, which would be mapped into 
    * the instance keyword = 40321 and sets
    * the alphabet as a String with the value "azAZ09".
    */
   
    public void init(String keyspec) throws Exception {
        super.initKey(keyspec, true);  // Remove duplicates from keyword
	blocksize = keyword.length();
	//        System.out.println(keyword + " " + blocksize);
    }

   /**
    * Initializes the RailfenceKey given a keyword and one or more alphabets.
    * @param keyword -- a string version of the keyword
    * @param alpha1, alpha2 -- Alphabets for plain/ciphertext respectively. May
    *  be identical.
    */ 
    public void init(String keyword, Alphabet alpha1, Alphabet alpha2) throws Exception { 
	if (alpha1 == null || alpha2 == null)
	    throw new Exception("RailFenceKey.init(): Null alphabet reference passed");
	//	System.out.println("RailFence key: keyword " + keyword);
        super.initKey(keyword, alpha1, alpha2);
        blocksize = keyword.length();
	//        System.out.println(keyword + " " + blocksize);
    }


    /**
    * Returns the name of the algorithm "RailFence".
    */
   
    public String getAlgorithm() {
        return "Railfence";
    }  
}//end RailFenceKey
