package hcrypto.engines;

import hcrypto.cipher.*;

/**
 * VariantBeaufortEngine.java implements a traditional VariantBeaufort Cipher for
 *  the full range of alphabets -- az, AZ, azAZ, azAZ09, printable characters, and all ASCII.
 *  The encoding method is based upon the following function:
 *      CipherChar = PlainChar - KeyChar
 *  The decoding method is based upon the following function:
 *      PlainChar = CipherChar + KeyChar
 *
 *  For a 26 letter alphabet, VariantBeaufort, with shift k, is equivalent to 
 *   Vigenere with shift 26-k. Thus, they are reciprocal. An encryption using
 *   Vigenere is equivalent to a decryption with VariantBeaufort and vice versa.
 *   Therefore this implementation merely redefines the encode() and decode()
 *   methods inherited from Vigenere.
 *  
 *<P>See also:
 *  <BLOCKQUOTE> 
 *      <BR><a href="VariantBeaufortKey.html">VariantBeaufortKey</a>
 *      <BR><a href="../cipher/Alphabet.html">Alphabet</a>
 *  </BLOCKQUOTE> 
 *
 */

public class VariantBeaufortEngine extends VigenereEngine {  
    
   /**
    * Creates a VariantBeaufortEngine and sets the <i>alphabetRangeOptions</i> instance variable
    * to "111111", which translates to all six alphabet options.
    */ 
    public VariantBeaufortEngine() {
	super();
    }

   /**
    * Initializes the VariantBeaufortEngine with the specified hKey.
    * @param hKey a VariantBeaufortKey.
    */
    
    protected void engineInit(HistoricalKey hKey) throws Exception {
        if ( !(hKey instanceof VariantBeaufortKey))
            throw new Exception("InvalidKey: VariantBeaufort requires VariantBeaufortKey");
	super.engineInit(hKey);
    }
   
   
   /**
    * engineEncode() is simply defined in terms of Vigenere decode()
    *  Characters which are not part of the chosen alphabet set are ignored.
    * @param s the String to be encrypted
    */

    public String engineEncode( String s ) throws Exception {
	return super.engineDecode(s);
    }  //engineEncode

    

    /**
    * engineDecode() is simply defined in terms of Vigenere encode()
    *  Characters which are not part of the chosen alphabet set are ignored.
    * @param s the String to be decrypted
    */
    
    public String engineDecode( String s ) throws Exception {
	return super.engineEncode(s);
    } //engineDecode
}  //VariantBeaufortEngine class


