package hcrypto.engines;

import hcrypto.cipher.*;

/**
 * This class represents a key for a VariantBeaufort cipher. The key
 * is entirely represented by a keyword String composed of characters from the chosen alphabet. 
 * <p>For this implementation of VariantBeaufort cipher any of the alphabet ranges
 * can be used.
 * 
 * For a 26 letter alphabet, A VariantBeaufort with key, k, is
 *  equivalent to Vigenere with key 26-k.  This class is therefore implemented
 *  as a subclass of VigenereKey.

 * <P>See also:
 *  <BLOCKQUOTE> 
 *      <BR><a href="VariantBeaufortEngine.html">ViegenerEngine</a>
 *      <BR><a href="../cipher/Alphabet.html">Alphabet</a>
 *  </BLOCKQUOTE> 
 */

public class VariantBeaufortKey extends VigenereKey {
   /**
    * Returns the name of the algorithm "VariantBeaufort".
    */
      
    public String getAlgorithm() { 
        return "VariantBeaufort"; 
    }   
}
