package hcrypto.provider;

/**
 *  This class represents the default provider for the
 *  <i>Historical Cipher API</i>.
 *  
 *  <P>To implement a Provider subclass, simply assign
 *  a name to the inherited <tt>name</tt> instance variable
 *  and place one call to <tt>put()</tt>, for each algorithm
 *  that is implemented by this provider. Each call to <tt>put()</tt>
 *  should give the name of the algorithm, the name of the
 *  bytecode "Engine" class that implements the algorithm, and the
 *  name of the bytecode "Key" class that implements the key. Here's
 *  an example constructor that implements a couple of ciphers:
 *
 * <pre>
 *   public MyProvider(String name) {
 *       this.name = name;
 *       put("Caesar", "hcrypto.engines.CaesarEngine", "hcrypto.engines.CaesarKey");        
 *       put("Vigenere", "hcrypto.engines.VigenereEngine", "hcrypto.engines.VigenereKey");        
 *  }
 * </pre>
 */

public class DefaultProvider extends Provider {

    /**
     * The constructor sets the name of the provider
     * and puts an entry into the main provider's internal
     * lists for the engine and the key of each algorithm it implements.
     */
    public DefaultProvider(String name) {
        this.name = name;
        put("Caesar", "hcrypto.engines.CaesarEngine", "hcrypto.engines.CaesarKey");
        put("Substitution", "hcrypto.engines.SubstitutionEngine", "hcrypto.engines.SubstitutionKey");
        put("Affine", "hcrypto.engines.AffineEngine", "hcrypto.engines.AffineKey");
        put("Vigenere", "hcrypto.engines.VigenereEngine", "hcrypto.engines.VigenereKey");
        put("Playfair", "hcrypto.engines.PlayfairEngine", "hcrypto.engines.PlayfairKey");
        put("Transposition", "hcrypto.engines.TranspositionEngine", "hcrypto.engines.TranspositionKey");
        put("PolySubstitution", "hcrypto.engines.PolySubstitutionEngine", "hcrypto.engines.PolySubstitutionKey");
        put("Railfence", "hcrypto.engines.RailfenceEngine", "hcrypto.engines.RailfenceKey");
	put("Enigma","hcrypto.engines.EnigmaEngine","hcrypto.engines.EnigmaKey"); 
   }
}
