package hcrypto.provider;

import hcrypto.provider.*;

/**
 * This class provides an example of programmer-defined Provider.
 * This provider implements a Caesar cipher. To implement any
 * cipher, the programmer must define an engine, which contains
 * the encryption algorithm, and  a key, which contains the 
 * associated key for that engine.
 *
 * <P>To use a provider in an application program, use the static
 * <tt>Provider.addProvider()</tt> method to add the provider
 * to the list of providers available to the program:
 * <pre>
 *   public static void main (String args[]) throws Exception {
 *       Provider.addProvider(new DefaultProvider("Default"));
 *       Provider.addProvider(new RamProvider("Ram"));
 *       ...
 *   }
 * </pre>
 *
 *<P>Once the program has the provider, its ciphers can
 * be used by the program as follows:
 * <pre>
 *      Cipher cipher = Cipher.getInstance("Caesar", "Ram");
 *      HistoricalKey key = HistoricalKey.getInstance("Caesar", cipher.getProvider());
 *      key.init("55/printable");
 *      cipher.init(key);
 *      String c1encrypt = cipher.encrypt(secret);
 * </pre>
 *
 * In this case an instance of the Caesar cipher implemented by the "Ram" provider 
 * will be created.  Note that the CaesarEngine class is a subclass of 
 * CipherEngine and the CaesarKey class is a subclass of HistoricalKey.
 *
 *
 * <P>See also:
 * <BLOCKQUOTE>
 * <BR><A href="DefaultProvider.html">DefaultProvider</A>
 * <BR><A href="Provider.html">DefaultProvider</A>
 * <BR><A href="../cipher/CipherEngine.html">CipherEngine</A>
 * <BR><A href="../cipher/HistoricalKey.html">HistoricalKey</A>
 * </BLOCKQUOTE>
 */

public class RamProvider extends Provider {

    public RamProvider(String name) {
        this.name = name;
        put("Caesar", "hcrypto.engines.CaesarEngine","hcrypto.engines.CaesarKey");        
	put("RailFence","hcrypto.engines.RailFenceEngine","hcrypto.engines.RailFenceKey"); 
	put("Alberti","hcrypto.engines.AlbertiEngine","hcrypto.engines.AlbertiKey"); 
	put("VariantBeaufort","hcrypto.engines.VariantBeaufortEngine","hcrypto.engines.VariantBeaufortKey"); 
	put("Beaufort","hcrypto.engines.BeaufortEngine","hcrypto.engines.BeaufortKey"); 
	put("TypeIV","hcrypto.engines.TypeIVEngine","hcrypto.engines.TypeIVKey"); 
    }
}
